% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_alias.R
\name{get_alias}
\alias{get_alias}
\alias{get_alias.labelled}
\alias{get_alias.default}
\alias{get_alias.data.frame}
\alias{get_alias.list}
\title{Get Aliases of column names}
\usage{
get_alias(x, ...)

\method{get_alias}{labelled}(x, ...)

\method{get_alias}{default}(x, ...)

\method{get_alias}{data.frame}(x, ...)

\method{get_alias}{list}(x, ...)
}
\arguments{
\item{x}{An object. Aliases will be retrieved of \code{x}.}

\item{...}{Passed from and to other methods.}
}
\value{
For atomic vectors a character of \code{NULL}; for non-atomic vectors the results of \code{get_alias} applied to its elements.
}
\description{
Retrieves attributes \code{label} and \code{units} of class labelled and attribute \code{alias} otherwise.
}
\details{
We use \code{\link[base]{attributes}} here, to assign alternative names to columns.
Also class \code{labelled} created by Hmisc's \code{\link[Hmisc]{label}} is supported.

This is a workhorse function, see \code{create_alias_mapping} for the high level function
}
\section{Methods (by class)}{
\itemize{
\item \code{labelled}: Retrieve attributes \code{label} and \code{units}, if available.
Units are bracketed by '[]'. See also \code{\link[Hmisc]{label}} and \code{\link[Hmisc]{units}}.
The user may alter this method via \code{\link{atable_options}}, see help there.

\item \code{default}: Retrieve attribute \code{alias} via \code{\link[base]{attr}}.
This attribute may be an arbitrary character.
If there is no attribute \code{alias}, then \code{get_alias.default} returns \code{NULL}.

\item \code{data.frame}: Calls \code{get_alias} on every column.

\item \code{list}: Calls \code{get_alias} on every element of the list.
}}

