% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_tests.R
\name{format_tests}
\alias{format_tests}
\alias{format_tests.htest}
\alias{format_tests.htest_with_effect_size}
\alias{format_tests.default}
\title{Formats hypothesis test results}
\usage{
format_tests(x, ...)

\method{format_tests}{htest}(x, format_tests.htest = NULL, ...)

\method{format_tests}{htest_with_effect_size}(x, format_tests.htest_with_effect_size = NULL, ...)

\method{format_tests}{default}(x, ...)
}
\arguments{
\item{x}{An object.}

\item{...}{Passed from and to other methods.}

\item{format_tests.htest}{Either \code{NULL} or a function. Default is \code{NULL}.
If a function, then it will replace \code{format_tests.htest}.
The function must mimic \code{\link{format_tests}}: arguments are \code{x} and the ellipsis ... .
Result is a data.frame with 1 rows and unique colnames.}

\item{format_tests.htest_with_effect_size}{Analog to argument format_tests.htest}
}
\value{
A non-empty data.frame with one row.
See also function \code{\link{check_format_tests}}.
}
\description{
The results of function \code{\link{two_sample_htest}} and \code{\link{multi_sample_htest}}
 must be formated before printing. \code{format_tests} does this.
}
\details{
This function defines which test results are printed in the final table and how they are formated.

The format depends on the class \code{x}. See section methods.

If you are not pleased with the current format you may alter these functions.
But you must keep the original output-format, see section Value.
Function \code{\link{check_format_tests}} checks if the output of \code{format_tests} is suitable for further processing.
}
\section{Methods (by class)}{
\itemize{
\item \code{htest}: Defines how to format class \code{htest}.
Returns a data.frame with 1 rows. Column \code{p} contains the p-value of the \code{x}.

\item \code{htest_with_effect_size}: Defines how to format class \code{htest_with_effect_size}.
Returns a data.frame with 1 rows. Column \code{p} contains the p-value of the \code{x}.
Column \code{stat} contains the teststatistic.
Column \code{Effect Size (CI)} contains a effect size and its 95\% Confidence interval.

\item \code{default}: Tries to cast to data.frame with one row. Uses the names of the list as colnames.
}}

