% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate-spatial-overlap.R
\name{calculate_spatial_overlap}
\alias{calculate_spatial_overlap}
\title{Calculate 3d overlap of predator groups with their prey over time using Schoener Index.}
\usage{
calculate_spatial_overlap(biomass_spatial, dietmatrix, agemat)
}
\arguments{
\item{biomass_spatial}{Biomass timeseries of each group and ageclass per polygon
and layer. This dataframe should be generated with \code{\link{calculate_biomass_spatial}}.}

\item{dietmatrix}{Availability matrix given in the biological parameter file.
This dataframe should be generated with \code{\link{load_dietmatrix}}. Please
make sure to use \code{convert_names = TRUE} in \code{\link{load_dietmatrix}}.}

\item{agemat}{First mature age class for age structured groups. This dataframe should
be generated with \code{\link{prm_to_df}} using "age_mat" as parameter.}
}
\value{
List of Schoener's similarity indices ranging from 1 (perfect overlap) to
0 (zero overlap). Dataframe in first listentry gives pred, pred agecl, prey, preyageclass
specific index. Dataframe in second listentry gives index per pred, pred agecl. Si is calculated
as weighted mean with the availabilities as weights.
}
\description{
Calculate 3d overlap of predator groups with their prey over time using Schoener Index.
}
\examples{
# Using built in datasets.
d <- system.file("extdata", "setas-model-new-trunk", package = "atlantistools")
prm_biol <- file.path(d, "VMPA_setas_biol_fishing_Trunk.prm")
fgs <- file.path(d, "SETasGroupsDem_NoCep.csv")

dietmatrix <- load_dietmatrix(prm_biol, fgs, convert_names = TRUE)
agemat <- prm_to_df(prm_biol = prm_biol, fgs = fgs,
                    group = get_age_acronyms(fgs = fgs),
                    parameter = "age_mat")

sp_overlap <- calculate_spatial_overlap(biomass_spatial = ref_bio_sp,
                                        dietmatrix = dietmatrix,
                                        agemat = agemat)
}
