% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load-txt.R
\name{load_txt}
\alias{load_txt}
\title{Function to load various txt files from Atlantis simulations}
\usage{
load_txt(file, id_col = "Time")
}
\arguments{
\item{file}{Character string giving the connection of the output file.
The filename usually contains \code{output} and ends in \code{.txt}".}

\item{id_col}{Character strings giving the names of the columns which are not variables.
Data from all other columns will be gathered with tidyr. Default is \code{"Time"}.}
}
\value{
Dataframe in tidy format!
}
\description{
Function to load various txt files from Atlantis simulations
}
\examples{
d <- system.file("extdata", "setas-model-new-becdev", package = "atlantistools")
file <- file.path(d, "outputSETASSSB.txt")
load_txt(file)

file <- file.path(d, "outputSETASYOY.txt")
load_txt(file)
}
\seealso{
Other load functions: \code{\link{load_box}},
  \code{\link{load_bps}}, \code{\link{load_dietcheck}},
  \code{\link{load_fgs}}, \code{\link{load_init_age}},
  \code{\link{load_init}}, \code{\link{load_nc_physics}},
  \code{\link{load_nc}}, \code{\link{load_rec}},
  \code{\link{load_spec_mort}}
}
