% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agg-data.R
\name{agg_data}
\alias{agg_data}
\alias{agg_perc}
\alias{group_data}
\title{Aggregate data using dplyr functionality.}
\usage{
agg_data(data, col = "atoutput", groups, out = "atoutput", fun)

agg_perc(data, col = "atoutput", groups, out = "atoutput")

group_data(data, groups)
}
\arguments{
\item{data}{Dataframe the aggregation is applied to.}

\item{col}{Column of the dataframe the summarise function is applied.
Default is \code{atoutput}.}

\item{groups}{Vector of character strings giving the grouping variables.}

\item{out}{Character string specifying the name of the output column.
Default is \code{atoutput}.}

\item{fun}{Aggregation function to apply.}
}
\value{
grouped datarame with the aggregated data.
}
\description{
This function is a 'wrapper' for the group_by and summarize procedure
used in dplyr to aggregate dataframes.
}
\examples{
agg_ref_nums <- agg_data(data = ref_nums, groups = c("species", "agecl"), fun = mean)
}
