% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str-split-twice.R
\name{str_split_twice}
\alias{str_split_twice}
\title{Extract numeric values from string.}
\usage{
str_split_twice(char, min_only = TRUE)
}
\arguments{
\item{char}{Character string.}

\item{min_only}{Logical specifying if only the first numeric value (\code{TRUE}) or
all numeric values (\code{FALSE}) should be returned. Default is \code{TRUE}.}
}
\value{
numeric values inside \code{char} string.
}
\description{
The function splits any character string at each tab and space and returns
all (min_only = FALSE) or only the first (min_only = T) numeric value found in the string.
}
\examples{
str_split_twice(char = "Hello   15")
str_split_twice(char = "flag1 15  16\\t15", min_only = FALSE)
}
