% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load-dietmatrix.R
\name{load_dietmatrix}
\alias{load_dietmatrix}
\alias{write_diet}
\title{Extract the dietmatrix from the biological parameterfile}
\usage{
load_dietmatrix(prm_biol, fgs, transform = TRUE, convert_names = FALSE,
  version_flag = 2)

write_diet(dietmatrix, prm_biol, save_to_disc = TRUE)
}
\arguments{
\item{prm_biol}{Character string giving the connection to the biological parameterfile.
The filename usually contains \code{biol_fishing} and does end in \code{.prm}.}

\item{fgs}{Character string giving the connection to the functional groups file.
The filename usually contains \code{Groups} and does end in \code{.csv}.}

\item{transform}{Boolean indicating if the returned dataframe is displayed in
"long" (\code{transform = TRUE, default}) or "wide" (\code{transform = FALSE})
format. You should use the "wide" format in case you aim to change your
diet matrix entries.}

\item{convert_names}{Logical indicating if group codes are transformed to LongNames (\code{TRUE})
or not (default = \code{FALSE}).}

\item{version_flag}{The version of ATLANTIS model. 1 for bec_dev, 2 for trunk. \code{default is 2.}.}

\item{dietmatrix}{Dataframe of the ATLANTIS dietmatrix generated with \code{load_dietmatrix}
using \code{transform = FALSE}.}

\item{save_to_disc}{Logical indicating if the resulting prm file should be overwritten
(\code{TRUE}) or not (\code{FALSE}). Defaults to \code{TRUE}.}
}
\value{
dataframe of the availability matrix in long format with columns
pred, pred_stanza (1 = juvenile, 2 = adult), prey_stanza, prey, avail, code.
}
\description{
Extracts the diet matrix as long dataframe from the biological paremeter file
of any ATLANTIS simulation.
}
\examples{
# Can be applied to trunk models.
d <- system.file("extdata", "setas-model-new-trunk", package = "atlantistools")
prm_biol <- file.path(d, "VMPA_setas_biol_fishing_Trunk.prm")
fgs <- file.path(d, "SETasGroupsDem_NoCep.csv")

dm <- load_dietmatrix(prm_biol, fgs)
head(dm, n = 10)

# Use write_diet to update your existing parameterfile.
dietmatrix <- load_dietmatrix(prm_biol, fgs, transform = FALSE)

# Write is set to FALSE here for technical reasons. Make sure to set it to TRUE in case you
# want to update your file.
new_diet <- write_diet(dietmatrix, prm_biol, save_to_disc = FALSE)

# And to bec-dev models.
d <- system.file("extdata", "setas-model-new-becdev", package = "atlantistools")
prm_biol <- file.path(d, "VMPA_setas_biol_fishing_New.prm")
fgs <- file.path(d, "SETasGroups.csv")

dm <- load_dietmatrix(prm_biol, fgs, version_flag = 1)
head(dm, n = 10)

}
