% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotREC.R
\name{plotREC}
\alias{plotREC}
\title{Regression Error Characteristic Curves (REC)}
\usage{
plotREC(object, ...)
}
\arguments{
\item{object}{An object of class ModelAudit or modelResiduals.}

\item{...}{Other modelAudit or model Residuals objects to be plotted together.}
}
\value{
ggplot object
}
\description{
Error Characteristic curves are a generalization of ROC curves.
On the x axis of the plot there is an error tolerance and on the y axis there is a percentage of observations predicted within the given tolerance.
}
\details{
REC curve estimates the Cumulative Distribution Function (CDF) of the error

Area Over the REC Curve (REC) is a biased estimate of the expected error
}
\examples{
library(car)
lm_model <- lm(prestige~education + women + income, data = Prestige)
lm_au <- audit(lm_model, data = Prestige, y = Prestige$prestige)
plotREC(lm_au)

library(randomForest)
rf_model <- randomForest(prestige~education + women + income, data = Prestige)
rf_au <- audit(rf_model, data = Prestige, y = Prestige$prestige)
plotREC(lm_au, rf_au)


}
\references{
Bi J., Bennett K.P. (2003). Regression error characteristic curves, in: Twentieth International Conference on Machine Learning (ICML-2003), Washington, DC.
}
\seealso{
\code{\link{plot.modelAudit}, \link{plotROC}, \link{plotRROC}}
}
