% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_gini.R
\name{score_gini}
\alias{score_gini}
\title{Gini Coefficient}
\usage{
score_gini(object, data = NULL, y = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{explainer} created with function
\code{\link[DALEX]{explain}} from the DALEX package.}

\item{data}{New data that will be used to calcuate the score.
Pass \code{NULL} if you want to use \code{data} from \code{object}.}

\item{y}{New y parameter will be used to calculate score.}

\item{...}{Other arguments dependent on the type of score.}
}
\value{
An object of class \code{auditor_score}.
}
\description{
The Gini coefficient measures the inequality among values of a frequency distribution.
A Gini coefficient equals 0 means perfect equality, where all values are the same.
A Gini coefficient equals 100% expresses maximal inequality of values.
}
\examples{
library(DALEX)

# fit a model
model_glm <- glm(survived ~ ., family = binomial, data = titanic_imputed)

# create an explainer
exp_glm <- explain(model_glm,
                   data = titanic_imputed,
                   y = titanic_imputed$survived)

# calculate score
score_gini(exp_glm)

}
\seealso{
\code{\link{plot_roc}}
}
