% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{audrex}
\alias{audrex}
\title{audrex}
\usage{
audrex(
  data,
  targets,
  past,
  deriv,
  future,
  shift = 0,
  smoother = FALSE,
  ci = 0.8,
  holdout = 0.3,
  nrounds = 100,
  patience = 10,
  booster = "gbtree",
  max_depth = NULL,
  eta = NULL,
  gamma = NULL,
  min_child_weight = NULL,
  subsample = NULL,
  colsample_bytree = NULL,
  lambda = NULL,
  alpha = NULL,
  verbose = FALSE,
  reg = "squarederror",
  eval_metric = "rmse",
  starting_date = NULL,
  dbreak = NULL,
  days_off = NULL,
  min_set = 30,
  seed = 42,
  opt_metric = "mae",
  n_samp = 15,
  n_search = 15,
  acq = "ucb",
  kappa = 2.576,
  eps = 0,
  kernel = list(type = "exponential", power = 2)
)
}
\arguments{
\item{data}{A data frame with time series on columns and possibly a date column (not mandatory)}

\item{targets}{String. Names of ts features to be jointly analyzed: for each feature a distinct model is built using the others as regressors.}

\item{past}{Positive integer. The past dimension with number of time-steps in the past used for the prediction.}

\item{deriv}{Positive integer. Number of differentiation operations to perform on the original series. 0 = no change; 1: one diff; 2: two diff, and so on.}

\item{future}{Positive integer. The future dimension with number of time-steps to be predicted}

\item{shift}{Vector of positive integers. Allow for each ts feature to shift ahead of time. Zero means no shift. Length must be equal to the number of targets. Default: 0.}

\item{smoother}{Logical. Perform optimal smooting using standard loess. Default: FALSE}

\item{ci}{Confidence interval. Default: 0.8}

\item{holdout}{Positive numeric. Percentage of time series for holdout validation. Default: 0.5.}

\item{nrounds}{Positive numeric. Number of round for the extreme boosting machine. Look to xgboost for description. Default: 100.}

\item{patience}{Positive integer. Waiting rounds without improvement before xgboost stops. Default: 10}

\item{booster}{String. Optimization methods available are: "gbtree", "gblinear". Default: "gbtree".}

\item{max_depth}{Positive integer. Look to xgboost documentation for description. A vector with one or two positive integer for the search boundaries. The default value (NULL) sets automatic the values in c(1, 10).}

\item{eta}{Positive numeric. Look to xgboost documentation for description. A vector with one or two positive numeric between (0, 1] for the search boundaries. The default value (NULL) sets automatic the values in c(0.001, 1).}

\item{gamma}{Positive numeric. Look to xgboost documentation for description. A vector with one or two positive numeric for the search boundaries. The default value (NULL) sets automatic the values in c(0.001, 100).}

\item{min_child_weight}{Positive numeric. Look to xgboost documentation for description. A vector with one or two positive numeric for the search boundaries. The default value (NULL) sets automatic the values in c(1, 100).}

\item{subsample}{Positive numeric. Look to xgboost documentation for description. A vector with one or two positive numeric between (0, 1] for the search boundaries. The default value (NULL) sets automatic the values in c(0.1, 1).}

\item{colsample_bytree}{Positive numeric. Look to xgboost documentation for description. A vector with one or two positive numeric between (0, 1] for the search boundaries. The default value (NULL) sets automatic the values in c(0.1, 1).}

\item{lambda}{Positive numeric. Look to xgboost documentation for description. A vector with one or two positive numeric for the search boundaries. The default value (NULL) sets automatic the values in c(0.1, 100).}

\item{alpha}{Positive numeric. Look to xgboost documentation for description. A vector with one or two positive numeric for the search boundaries. The default value (NULL) sets automatic the values in c(0.1, 100).}

\item{verbose}{Logical. Default: TRUE}

\item{reg}{String. Learning objective function. Options are: "squarederror", "pseudohubererror".Default: "squarederror".}

\item{eval_metric}{String. Evaluation metric for the boosting algorithm. Options are: "rmse", "mae", "mape".Default: "mae".}

\item{starting_date}{Date. Initial date to assign temporal values to the series. Default: NULL (progressive numbers).}

\item{dbreak}{String. Minimum time marker for x-axis, in liberal form: i.e., "3 months", "1 week", "20 days". Default: NULL.}

\item{days_off}{String. Weekdays to exclude (i.e., c("saturday", "sunday")). Default: NULL.}

\item{min_set}{Positive integer. Minimun number for validation set in case of automatic resize of past dimension. Default: 30.}

\item{seed}{Random seed. Default: 42.}

\item{opt_metric}{String. Parameter for selecting the best model, averaging one-step error across all ts features. Default: "mae".}

\item{n_samp}{Positive integer. Number of samples for the Bayesian Optimization. Default: 15.}

\item{n_search}{Positive integer. Number of search steps for the Bayesian Optimization. Default: 15.}

\item{acq}{String. Parameter for Bayesian Optimization. For reference see rBayesianOptimization documentation. Default: "ucb".}

\item{kappa}{Positive numeric.Parameter for Bayesian Optimization. For reference see rBayesianOptimization documentation. Default: 2.576.}

\item{eps}{Positive numeric.Parameter for Bayesian Optimization. For reference see rBayesianOptimization documentation. Default: 0.}

\item{kernel}{List.Parameter for Bayesian Optimization. For reference see rBayesianOptimization documentation. Default: list(type = "exponential", power = 2).}
}
\value{
This function returns a list including:
\itemize{
\item best_par: the parameter of the best model selected through Bayesian Optimization
\item history: a table with the sampled models (n_samp + n_search), their parameters and optimization metric
\item best_model: results for the best selected model, including:
\itemize{
\item errors: training and testing errors for one-step and sequence for each ts feature (rmse, mae, mdae, mpe, mape, smape)
\item predictions: min, max, q25, q50, q75, quantiles at selected ci, mean, sd for each ts feature
\item pred_stats: some stats for each ts feature (iqr to min-max range, last-to-first iqr ratio, upside probability from ecdf)
}
\item time_log
}
}
\description{
audrex
}
\examples{
\donttest{
audrex(bitcoin_gold_oil, c("gold_close", "oil_Close"), past = 30, deriv = 1, future = 10)
}

}
\author{
Giancarlo Vercellino \email{giancarlo.vercellino@gmail.com}
}
