% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auk-split.r
\name{auk_split}
\alias{auk_split}
\title{Split an eBird data file by species}
\usage{
auk_split(file, species, prefix = "", ext = "txt", sep = "\\t",
  overwrite = FALSE)
}
\arguments{
\item{file}{character; input file.}

\item{species}{species character; species to filter and split by, provided as
scientific or English common names, or a mixture of both. These names must
match the official eBird Taxomony (\link{ebird_taxonomy}).}

\item{prefix}{character; a file and directory prefix. For example, if
splitting by species "A" and "B" and \code{prefix = "data/ebd_"}, the resulting
files will be "data/ebd_A.txt" and "data/ebd_B.txt".}

\item{ext}{character; file extension, typically "txt".}

\item{sep}{character; the input field separator, the eBird file is tab
separated by default. Must only be a single character and space delimited
is not allowed since spaces appear in many of the fields.}

\item{overwrite}{logical; overwrite output files if they already exists}
}
\value{
A vector of output filenames, one for each species.
}
\description{
Given an eBird Basic Dataset (EBD) and a list of species, split the file into
multiple text files, one for each species. This function is typically used
after \code{\link[=auk_filter]{auk_filter()}} has been applied if the resulting file is too large to
be read in all at once.
}
\examples{
\dontrun{
species <- c("Gray Jay", "Cyanocitta stelleri")
# get the path to the example data included in the package
# in practice, provide path to a filtered ebd file
# e.g. f <- "data/ebd_filtered.txt
f <- system.file("extdata/ebd-sample.txt", package = "auk")
# output to a temporary directory for example
# in practice, provide the path to the output location
# e.g. prefix <- "output/ebd_"
prefix <- file.path(tempdir(), "ebd_")
species_files <- auk_split(f, species = species, prefix = prefix)
}
}
\seealso{
Other text: \code{\link{auk_clean}},
  \code{\link{auk_select}}
}
\concept{text}
