% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auk-set-ebd-path.r
\name{auk_set_ebd_path}
\alias{auk_set_ebd_path}
\title{Set the path to EBD text files}
\usage{
auk_set_ebd_path(path, overwrite = FALSE)
}
\arguments{
\item{path}{character; directory where the EBD text files are stored, e.g.
\code{"/home/matt/ebd"}.}

\item{overwrite}{logical; should the existing \code{EDB_PATH} be overwritten if it
has already been set in .Renviron.}
}
\value{
Edits .Renviron, then returns the AWK path invisibly.
}
\description{
Users of \code{auk} are encouraged to set the path to the directory containing the
eBird Basic Dataset (EBD) text files in the \code{EBD_PATH} environment variable.
All functions referencing the EBD or sampling event data files will check in
this directory to find the files, thus avoiding the need to specify the full
path every time. This will increase the portability of your code. Use this
function to set \code{EBD_PATH} in your .Renviron file; it is
also possible to manually edit the file.
}
\examples{
\dontrun{
auk_set_ebd_path("/home/matt/ebd")
}
}
\seealso{
Other paths: 
\code{\link{auk_get_awk_path}()},
\code{\link{auk_get_ebd_path}()},
\code{\link{auk_set_awk_path}()}
}
\concept{paths}
