% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auk-complete.R
\name{auk_complete}
\alias{auk_complete}
\title{Filter out incomplete checklists from the eBird data}
\usage{
auk_complete(x)
}
\arguments{
\item{x}{\code{auk_ebd} or \code{auk_sampling} object; reference to file created by
\code{\link[=auk_ebd]{auk_ebd()}} or \code{\link[=auk_sampling]{auk_sampling()}}.}
}
\value{
An \code{auk_ebd} object.
}
\description{
Define a filter for the eBird Basic Dataset (EBD) to only keep complete
checklists, i.e. those for which all birds seen or heard were recorded. These
checklists are the most valuable for scientific uses since they provide
presence and absence data.This function only defines the filter and, once all
filters have been defined, \code{\link[=auk_filter]{auk_filter()}} should be used to call AWK and
perform the filtering.
}
\details{
This function can also work with on an \code{auk_sampling} object if the
user only wishes to filter the sampling event data.
}
\examples{
system.file("extdata/ebd-sample.txt", package = "auk") \%>\%
  auk_ebd() \%>\%
  auk_complete()
}
\seealso{
Other filter: 
\code{\link{auk_bbox}()},
\code{\link{auk_bcr}()},
\code{\link{auk_breeding}()},
\code{\link{auk_country}()},
\code{\link{auk_county}()},
\code{\link{auk_date}()},
\code{\link{auk_distance}()},
\code{\link{auk_duration}()},
\code{\link{auk_exotic}()},
\code{\link{auk_extent}()},
\code{\link{auk_filter}()},
\code{\link{auk_last_edited}()},
\code{\link{auk_observer}()},
\code{\link{auk_project}()},
\code{\link{auk_protocol}()},
\code{\link{auk_species}()},
\code{\link{auk_state}()},
\code{\link{auk_time}()},
\code{\link{auk_year}()}
}
\concept{filter}
