% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arima.R
\name{extract_params.Arima}
\alias{extract_params.Arima}
\title{extract_params.Arima}
\usage{
\method{extract_params}{Arima}(object, ...)
}
\arguments{
\item{object}{an object of class "Arima"}

\item{...}{further arguments passed to or from other methods}
}
\value{
PFA as a list-of-lists that can be inserted into a cell or pool
}
\description{
Extract model parameters from an ARIMA model created 
using the arima(), Arima(), or auto.arima() functions
}
\examples{
model <- stats::arima(presidents, c(3, 0, 0))
extracted_model <- extract_params(model)

model <- forecast::Arima(USAccDeaths, order=c(2,2,2), seasonal=c(0,2,2))
extracted_model <- extract_params(model)

model <- forecast::auto.arima(WWWusage)
extracted_model <- extract_params(model)
}
