% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{loss_score_ranking}
\alias{loss_score_ranking}
\title{Ranks tuning parameters according to loss functions}
\usage{
loss_score_ranking(score, loss.fun)
}
\arguments{
\item{score}{A data set containing loss function names, the loss function
values, and the tuning parameter values.}

\item{loss.fun}{Loss function. A character-valued scalar indicating whether
prediction loss should be measured by the mean squared error (\code{MSE})
or the mean absolute error (\code{MAE}). Default is \code{MSE}.}
}
\value{
Returns a tibble containing the parameter grid as well as a rank
  column that corresponds to the cross-validation rank of a parameter
  combination across all loss function scores.
}
\description{
\code{loss_score_ranking()} ranks tuning parameters according to the scores
received in multiple loss functions.
}
