% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_lasso.R
\name{run_lasso_mc_lambda}
\alias{run_lasso_mc_lambda}
\title{Lasso multicore tuning.}
\usage{
run_lasso_mc_lambda(
  y,
  L1.x,
  L2.x,
  L2.unit,
  L2.reg,
  loss.unit,
  loss.fun,
  data,
  cores,
  L2.fe.form,
  L1.re,
  lambda
)
}
\arguments{
\item{y}{Outcome variable. A character vector containing the column names of
the outcome variable. A character scalar containing the column name of
the outcome variable in \code{survey}.}

\item{L1.x}{Individual-level covariates. A character vector containing the
column names of the individual-level variables in \code{survey} and
\code{census} used to predict outcome \code{y}. Note that geographic unit
is specified in argument \code{L2.unit}.}

\item{L2.x}{Context-level covariates. A character vector containing the
column names of the context-level variables in \code{survey} and
\code{census} used to predict outcome \code{y}.}

\item{L2.unit}{Geographic unit. A character scalar containing the column
name of the geographic unit in \code{survey} and \code{census} at which
outcomes should be aggregated.}

\item{L2.reg}{Geographic region. A character scalar containing the column
name of the geographic region in \code{survey} and \code{census} by which
geographic units are grouped (\code{L2.unit} must be nested within
\code{L2.reg}). Default is \code{NULL}.}

\item{loss.unit}{Loss function unit. A character-valued scalar indicating
whether performance loss should be evaluated at the level of individual
respondents (\code{individuals}), geographic units (\code{L2 units}) or at
both levels. Default is \code{c("individuals", "L2 units")}. With multiple
loss units, parameters are ranked for each loss unit and the loss unit with
the lowest rank sum is chosen. Ties are broken according to the order in
the search grid.}

\item{loss.fun}{Loss function. A character-valued scalar indicating whether
prediction loss should be measured by the mean squared error (\code{MSE}),
the mean absolute error (\code{MAE}), binary cross-entropy
(\code{cross-entropy}), mean squared false error (\code{msfe}), the f1
score (\code{f1}), or a combination thereof. Default is \code{c("MSE",
"cross-entropy","msfe", "f1")}. With multiple loss functions, parameters
are ranked for each loss function and the parameter combination with the
lowest rank sum is chosen. Ties are broken according to the order in the
search grid.}

\item{data}{Data for cross-validation. A \code{list} of \eqn{k}
\code{data.frames}, one for each fold to be used in \eqn{k}-fold
cross-validation.}

\item{cores}{The number of cores to be used. An integer indicating the number
of processor cores used for parallel computing. Default is 1.}

\item{L2.fe.form}{The fixed effects part of the Lasso classifier formula. The
formula is inherited from \code{run_lasso}.}

\item{L1.re}{A list of random effects for the Lasso classifier formula. The
formula is inherited from \code{run_lasso}.}

\item{lambda}{Lasso penalty parameter. A numeric \code{vector} of
non-negative values. The penalty parameter controls the shrinkage of the
context-level variables in the lasso model. Default is a sequence with
minimum 0.1 and maximum 250 that is equally spaced on the log-scale. The
number of values is controlled by the \code{lasso.n.iter} parameter.}
}
\value{
The cross-validation errors for all models. A list.
}
\description{
\code{run_lasso_mc_lambda} is called from within \code{run_lasso}. It
tunes using multiple cores.
}
