% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcm.R
\name{pcm}
\alias{pcm}
\alias{fitStats.pcm}
\alias{summary.pcm}
\alias{print.pcm}
\title{Estimation of The Partial Credit Model (PCM)}
\usage{
pcm(X, init_par = c(), setting = c(), method = c("fast", "novel"))

\method{fitStats}{pcm}(obj, isAlpha = TRUE, isTraced = FALSE)

\method{summary}{pcm}(object, ...)

\method{print}{pcm}(x, ...)
}
\arguments{
\item{X}{Input dataset as matrix or data frame with ordinal responses (starting from 0);
rows represent individuals, columns represent items.}

\item{init_par}{a vector of initial values of the estimated parameters.}

\item{setting}{a list of the optimization control setting parameters. See \code{\link[autoRasch:autoRaschOptions]{autoRaschOptions()}.}}

\item{method}{The implementation option of log likelihood function. \code{fast} using a \code{c++} implementation and \code{novel} using an \code{R} implementation.}

\item{obj}{The object of class \code{'pcm'}.}

\item{isAlpha}{Boolean value that indicates whether the discrimination parameters is needed to be estimated or not.
The discrimination parameters are estimated using the corresponding models (GPCM or GPCM-DIF).}

\item{isTraced}{A list of some matrices, i.e., the expected values, the variances, the curtosis, and the standardized residual matrix.}

\item{object}{The object of class \code{'pcm'}.}

\item{...}{Further arguments to be passed.}

\item{x}{The object of class \code{'pcm'}.}
}
\value{
\strong{\code{pcm()} will return a \code{\link[base:list]{list}} which contains:}
\item{X}{   The dataset that is used for estimation.}
\item{mt_vek}{   A vector of the highest response given to items.}
\item{itemName}{   The vector of names of items (columns) in the dataset.}
\item{loglik}{   The log likelihood of the estimation.}
\item{hessian}{   The hessian matrix. Only when the \code{isHessian = TRUE}.}
\item{beta}{   A vector of the difficulty parameter of each categories of items (thresholds).}
\item{theta}{   A vector of the ability parameters of each individuals.}

\strong{\code{fitStats()} will return a \code{\link[base:list]{list}} which contains:}
\item{alpha}{   A vector of estimated discrimination parameters for each items.}
\emph{i.fit}{   Item fit statistics.}
\itemize{
\item{i.outfitMSQ}{   A vector of Outfit mean square values for each items.}
\item{i.infitMSQ}{   A vector of Infit mean square values for each items.}
\item{i.outfitZ}{   A vector of OutfitZ values for each items.}
\item{i.infitZ}{   A vector of InfitZ values for each items.}
}
\emph{p.fit}{   Person fit statistics.}
\itemize{
\item{p.outfitMSQ}{   A vector of Outfit mean square values for each persons.}
\item{p.infitMSQ}{   A vector of Infit mean square values for each persons.}
\item{p.outfitZ}{   A vector of OutfitZ values for each persons.}
\item{p.infitZ}{   A vector of InfitZ values for each persons.}
}
\emph{traceMat}{   Some computed matrices in the process. Only if \code{isTraced = TRUE}}
\itemize{
\item{emat}{   The expected values matrix.}
\item{vmat}{   The variance matrix.}
\item{cmat}{   The curtosis matrix.}
\item{std.res}{   The standardized residual.}
}
}
\description{
This function computes the parameter estimates of a partial credit model for dichotomous and polytomous responses
by using penalized joint maximum likelihood estimation (PJMLE). Inputting a dichotomous responses to this model,
will automatically transforms the PCM to the Rasch model.

\code{fitStats} compute the fit statistics (e.g., Outfit and Infit) of the PCM model estimation (items and persons).
}
\examples{
pcm_res <- pcm(shortDIF)
summary(pcm_res)

#To summarize only for beta parameters
summary(pcm_res, par="beta")
fit_res <- fitStats(pcm_res, isTraced = TRUE)
itemfit(fit_res)
personfit(fit_res)
plot_fitStats(fit_res, toPlot = c("alpha","outfit"), useName = TRUE)

}
\references{
Wright, B. D., & Masters, G. N. (1982). Rating Scale Analysis. Chicago: MESA Press.

Masters, G. N. (1982). A rasch model for partial credit scoring. Psychometrika, 47(2), 149–174. https://doi.org/10.1007/BF02296272. \cr\cr
Wright, B. D., & Masters, G. N. (1990). Computation of outfit and infit statistics. Rasch Measurement Transactions, 3(4), 84–85. Retrieved from https://www.rasch.org/rmt/rmt34e.htm
}
\seealso{
\code{\link{pcm}}, \code{\link{gpcm}}
}
