% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggcmprsk2.R
\name{ggcmprsk2}
\alias{ggcmprsk2}
\title{Compare cumulative incidence to th Kaplan-Meier estimate}
\usage{
ggcmprsk2(
  x,
  data,
  id = c("disease", "other"),
  se = FALSE,
  xpos = c(2, 2),
  ypos = c(0.25, 0.7),
  ylabs = NULL,
  xlab = NULL,
  label = NULL,
  plot = TRUE
)
}
\arguments{
\item{x}{A formula as time+status~1}

\item{data}{A data.frame}

\item{id}{Character vector of length2}

\item{se}{logical whether or not show confidence interval}

\item{xpos}{numeric x-axis position of label}

\item{ypos}{numeric y-axis position of label}

\item{ylabs}{string vector of length 2. y axis labels}

\item{xlab}{A character. The x-axis label}

\item{label}{string vector of length 2. Label names}

\item{plot}{logical Whether or not print plot}
}
\value{
A list containing the following components:
\describe{
  \item{df}{A long-form data.frame consist of time, est, upper,lower, id, method}
  \item{df3}{A data.frame for label consist of x, y, label, id}
  \item{p}{A ggplot object}
}
}
\description{
Compare cumulative incidence to th Kaplan-Meier estimate
}
\examples{
require(dplyr)
data(prostateSurvival,package="asaur")
prostateHighRisk <- prostateSurvival \%>\%
  filter(grade=="poor" & stage=="T2",ageGroup=="80+")
ggcmprsk2(survTime/12+status~1,data=prostateHighRisk,
  id=c("prostate cancer","other causes"))
}
