% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit2newdata.R
\name{fit2newdata}
\alias{fit2newdata}
\title{Make a new data of mean value or most frequent value}
\usage{
fit2newdata(
  fit,
  xnames = NULL,
  pred.values = list(),
  maxy.lev = 5,
  median = TRUE,
  digits = 1
)
}
\arguments{
\item{fit}{An object of class "coxph"}

\item{xnames}{character Names of explanatory variable to plot}

\item{pred.values}{A list A list of predictor values}

\item{maxy.lev}{Integer Maximum unique length of a numeric variable to be treated as categorical variables}

\item{median}{logical If TRUE, select median value for numerical variable. Otherwise select most frequent value}

\item{digits}{integer indicating the number of decimal places}
}
\value{
A data.frame
}
\description{
Make a new data of mean value or most frequent value
}
\examples{
require(survival)
data(cancer,package="survival")
fit=coxph(Surv(time,status)~rx+sex+age,data=colon)
fit=coxph(Surv(time,status)~rx+age+strata(sex),data=colon)
fit=survreg(Surv(time, status) ~ ph.ecog + age + sex, data=lung, dist="weibull")
fit2newdata(fit)
fit2newdata(fit,pred.values=list(sex=0,age=58))
fit2newdata(fit,pred.values=list(age=c(20,40,60,80),sex=2,ph.ecog=3))
}
