% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_output.R
\name{generate_outputs}
\alias{generate_outputs}
\title{Generate all outputs from a spec}
\usage{
generate_outputs(spec, datasets, verbose_level = 2)
}
\arguments{
\item{spec}{Specification list generated by `read_spec`}

\item{datasets}{A `list` of datasets}

\item{verbose_level}{Verbose level of messages be displayed. See details for further information.}
}
\value{
No return value, called for side effects
}
\description{
Generate all outputs from a spec
}
\details{
`verbose_level` is used to control how many messages are printed out.
By default, `2` will show all filter messages and show output generation message.
`1` will show output generation message only.
`0` will display no message.
}
\examples{
library(dplyr, warn.conflicts = FALSE)
data <- list(
  adsl = eg_adsl,
  adae = eg_adae
)
filters::load_filters(
  yaml_file = system.file("filters.yml", package = "autoslider.core"),
  overwrite = TRUE
)

spec_file <- system.file("spec.yml", package = "autoslider.core")
spec_file \%>\%
  read_spec() \%>\%
  filter_spec(output \%in\% c("t_dm_slide_IT", "t_ae_slide_SE")) \%>\%
  generate_outputs(datasets = data)

}
\author{
- Thomas Neitmann (`neitmant`)
- Liming Li (`Lil128`)
}
