% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_ae_pt_soc_slide.R
\name{t_ae_pt_soc_slide}
\alias{t_ae_pt_soc_slide}
\title{Adverse event table}
\usage{
t_ae_pt_soc_slide(
  adsl,
  adae,
  arm,
  cutoff = NA,
  prune_by_total = FALSE,
  split_by_study = FALSE,
  side_by_side = NULL
)
}
\arguments{
\item{adsl}{ADSL data set, dataframe}

\item{adae}{ADAE data set, dataframe}

\item{arm}{Arm variable, character}

\item{cutoff}{Cutoff threshold}

\item{prune_by_total}{Prune according total column}

\item{split_by_study}{Split by study, building structured header for tables}

\item{side_by_side}{"GlobalAsia" or "GlobalAsiaChina" to define the side by side requirement}
}
\value{
rtables object
}
\description{
Adverse event table
}
\examples{
library(dplyr)
# Example 1
adsl <- eg_adsl \%>\%
  dplyr::mutate(TRT01A = factor(TRT01A, levels = c("A: Drug X", "B: Placebo")))
adae <- eg_adae \%>\%
  dplyr::mutate(
    TRT01A = factor(TRT01A, levels = c("A: Drug X", "B: Placebo")),
    ATOXGR = AETOXGR
  )
out <- t_ae_pt_soc_slide(adsl, adae, "TRT01A", 2)
print(out)
generate_slides(out, paste0(tempdir(), "/ae.pptx"))


# Example 2, prune by total column
out2 <- t_ae_pt_soc_slide(adsl, adae, "TRT01A", 25, prune_by_total = TRUE)
print(out2)
generate_slides(out2, paste0(tempdir(), "/ae2.pptx"))
}
