% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_dd_slide.R
\name{t_dd_slide}
\alias{t_dd_slide}
\title{Death table}
\usage{
t_dd_slide(adsl, arm = "TRT01A", split_by_study = FALSE, side_by_side = NULL)
}
\arguments{
\item{adsl}{ADSL data set, dataframe}

\item{arm}{Arm variable, character, "`TRT01A" by default.}

\item{split_by_study}{Split by study, building structured header for tables}

\item{side_by_side}{used for studies in China. "GlobalAsia" or "GlobalAsiaChina" to define
the side by side requirement.}
}
\value{
rtables object
}
\description{
Death table
}
\note{
* Default arm variables are set to `"TRT01A"` for safety output, and
 `"TRT01P"` for efficacy output
}
\examples{
library(dplyr)
adsl <- eg_adsl \%>\% preprocess_t_dd()
out1 <- t_dd_slide(adsl, "TRT01A")
print(out1)
generate_slides(out1, paste0(tempdir(), "/dd.pptx"))

out2 <- t_dd_slide(adsl, "TRT01A", split_by_study = TRUE)
print(out2)
}
