% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/g_mean_general.R
\name{g_mean_general}
\alias{g_mean_general}
\title{Plot mean values general function
used by wrappers `g_vs_slide`,`g_lb_slide`, & `g_eg_slide`}
\usage{
g_mean_general(
  adsl,
  data,
  variables = control_lineplot_vars(group_var = "TRT01P"),
  by_vars = c("USUBJID", "STUDYID"),
  subtitle = "Plot of Mean and 95\% Confidence Limits by Visit.",
  ...
)
}
\arguments{
\item{adsl}{ADSL dataset}

\item{data}{dataset containing the variable of interest in PARAMCD and AVAL}

\item{variables}{(named \code{character}) vector of variable names in \code{df} which should include:
\itemize{
\item \code{x} (\code{string})\cr name of x-axis variable.
\item \code{y} (\code{string})\cr name of y-axis variable.
\item \code{group_var} (\code{string} or \code{NULL})\cr name of grouping variable (or strata), i.e. treatment arm.
Can be \code{NA} to indicate lack of groups.
\item \code{subject_var} (\code{string} or \code{NULL})\cr name of subject variable. Only applies if \code{group_var} is
not NULL.
\item \code{paramcd} (\code{string} or \code{NA})\cr name of the variable for parameter's code. Used for y-axis label and plot's
subtitle. Can be \code{NA} if \code{paramcd} is not to be added to the y-axis label or subtitle.
\item \code{y_unit} (\code{string} or \code{NA})\cr name of variable with units of \code{y}. Used for y-axis label and plot's subtitle.
Can be \code{NA} if y unit is not to be added to the y-axis label or subtitle.
\item \code{facet_var} (\code{string} or \code{NA})\cr name of the secondary grouping variable used for plot faceting, i.e. treatment
arm. Can be \code{NA} to indicate lack of groups.
}}

\item{by_vars}{variables to merge the two datasets by}

\item{subtitle}{character scalar forwarded to g_lineplot}

\item{...}{additional arguments passed to `tern::g_lineplot`}
}
\description{
adapted from https://insightsengineering.github.io/tlg-catalog/stable/graphs/other/mng01.html
}
\examples{
\dontshow{if (require('rsvg')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(dplyr)
advs_filtered <- eg_advs \%>\% filter(
  PARAMCD == "SYSBP"
)
out1 <- g_mean_general(eg_adsl, advs_filtered)
generate_slides(out1, paste0(tempdir(), "/g_mean.pptx"))
\dontshow{\}) # examplesIf}
}
\author{
Stefan Thoma (`thomas7`)
}
