% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avfintools.R
\name{get5}
\alias{get5}
\title{Get Stock Data at the 5 minute level localized to current time zone}
\usage{
get5(ticker, truncated = TRUE)
}
\arguments{
\item{ticker}{The ticker symbol as a string}

\item{truncated}{Option to limit output to hours closer to market open hours. Default is true.}
}
\value{
A data frame with daily data such as the high, low, open, close, and associated returns. Available in the global environment.
Default is truncated to show data more relevant to active trading hours. Adjusted to local time zone.
}
\description{
Summary statistics for the movements on the 5 minute level
}
\examples{
\dontrun{
get5("WTI")
get5("SPY", truncated = FALSE)
}
}
