% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{hass_region}
\alias{hass_region}
\title{Hass Avocado Regional Sales}
\format{
a dataframe with 16 variables.

\describe{
\item{week_ending}{The date of the last day of the week in YYYY-MM-DD format.}
\item{region}{Specific region within the US as defined by the Hass Avocado Board.}
\item{avg_price_nonorg}{The average selling price in US$ for non-organic Hass avocados. Not adjusted for inflation.}
\item{plu4046}{The amount of PLU 4046 Hass avocados sold by weight in US pounds. This does not include avocados sold in pre-packaged quantities. See vignette for more information about Hass PLUs.}
\item{plu4225}{The amount of PLU 4225 Hass avocados sold by weight in US pounds. This does not include avocados sold in pre-packaged quantities. See vignette for more information about Hass PLUs.}
\item{plu4770}{The amount of PLU 4770 Hass avocados sold by weight in US pounds. This does not include avocados sold in pre-packaged quantities. See vignette for more information about Hass PLUs.}
\item{small_nonorg_bag}{The amount of non-organic Hass avocados (they can be a mix of PLUs) sold in small pre-packaged containers/bags in US pounds. This does not include avocados sold individually. See vignette for more information about pre-packaged avocados.}
\item{large_nonorg_bag}{The amount of non-organic Hass avocados (they can be a mix of PLUs) sold in large pre-packaged containers/bags in US pounds. This does not include avocados sold individually. See vignette for more information about pre-packaged avocados.}
\item{xlarge_nonorg_bag}{The amount of non-organic Hass avocados (they can be a mix of PLUs) sold in extra-large pre-packaged containers/bags in US pounds. This does not include avocados sold individually. See vignette for more information about pre-packaged avocados.}
\item{avg_price_org}{The average selling price in US$ for organic Hass avocados. Not adjusted for inflation.}
\item{plu94046}{The amount of PLU 94046 Hass avocados sold by weight in US pounds. This does not include avocados sold in pre-packaged quantities. See vignette for more information about Hass PLUs.}
\item{plu94225}{The amount of PLU 94225 Hass avocados sold by weight in US pounds. This does not include avocados sold in pre-packaged quantities. See vignette for more information about Hass PLUs.}
\item{plu94770}{The amount of PLU 94770 Hass avocados sold by weight in US pounds. This does not include avocados sold in pre-packaged quantities. See vignette for more information about Hass PLUs.}
\item{small_org_bag}{The amount of organic Hass avocados (they can be a mix of PLUs) sold in small pre-packaged containers/bags in US pounds. This does not include avocados sold individually. See vignette for more information about pre-packaged avocados.}
\item{large_org_bag}{The amount of organic Hass avocados (they can be a mix of PLUs) sold in large pre-packaged containers/bags in US pounds. This does not include avocados sold individually. See vignette for more information about pre-packaged avocados.}
\item{xlarge_org_bag}{The amount of organic Hass avocados (they can be a mix of PLUs) sold in extra-large pre-packaged containers/bags in US pounds. This does not include avocados sold individually. See vignette for more information about pre-packaged avocados.}
}
}
\usage{
hass_region
}
\description{
Weekly summary of Hass avocado sales for the regions within the United States
}
\details{
This dataset contains a weekly sales summary for Hass avocados for regions (as defined by the Hass Avocado Board) within the US.
}
\keyword{datasets}
