% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_managed_prefix_list}
\alias{ec2_create_managed_prefix_list}
\title{Create Managed Prefix List}
\usage{
ec2_create_managed_prefix_list(
  PrefixListName,
  MaxEntries,
  AddressFamily,
  DryRun = NULL,
  Entry = NULL,
  TagSpecification = NULL,
  ClientToken = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{PrefixListName}{String.   A name for the prefix list.}

\item{MaxEntries}{Integer. The maximum number of entries for the prefix list.}

\item{AddressFamily}{String.   The IP address type.  Valid Values: \code{IPv4} \| \code{IPv6}}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{Entry}{List. One or more entries for the prefix list.[optional]}

\item{TagSpecification}{List. The tags to apply to the prefix list during creation.[optional]}

\item{ClientToken}{String.   Unique, case-sensitive identifier you provide to ensure the idempotency of the request.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Create Managed Prefix List
}
\section{PrefixListName}{


A name for the prefix list.

Constraints: Up to 255 characters in length. The name cannot start with
\code{com.amazonaws}.
}

\section{MaxEntries}{

The maximum number of entries for the prefix
list.
}

\section{AddressFamily}{


The IP address type.

Valid Values: \code{IPv4} \| \code{IPv6}
}

\section{DryRun}{

Checks whether you have the required permissions
for the action, without actually making the request, and provides an
error response. If you have the required permissions, the error response
is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{Entry}{

One or more entries for the
prefix list.
}

\section{TagSpecification}{

The tags to apply to the prefix list
during creation.
}

\section{ClientToken}{


Unique, case-sensitive identifier you provide to ensure the idempotency
of the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{Ensuring Idempotency}.

Constraints: Up to 255 UTF-8 characters in length.
}

