% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_import_snapshot_tasks}
\alias{ec2_describe_import_snapshot_tasks}
\title{Describe Import Snapshot Tasks}
\usage{
ec2_describe_import_snapshot_tasks(
  DryRun = NULL,
  Filters = NULL,
  ImportTaskId = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{Filters}{List. The filters.[optional]}

\item{ImportTaskId}{List. A list of import snapshot task IDs.[optional]}

\item{MaxResults}{Integer. The maximum number of results to return in a single call.[optional]}

\item{NextToken}{Characters, The token for the next page of results[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Describes your import snapshot
tasks.
}
\section{DryRun}{

Checks whether
you have the required permissions for the action, without actually
making the request, and provides an error response. If you have the
required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.
}

\section{Filters}{

The
filters.
}

\section{ImportTaskId}{

A list of import snapshot task
IDs.
}

\section{MaxResults}{

The maximum number of results to return in a
single call. To retrieve the remaining results, make another call with
the returned \code{NextToken} value.
}

