% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_instance_status}
\alias{ec2_describe_instance_status}
\title{Describe Instance Status}
\usage{
ec2_describe_instance_status(
  Filter = NULL,
  InstanceId = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  DryRun = NULL,
  IncludeAllInstances = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{InstanceId}{List.   The instance IDs.[optional]}

\item{MaxResults}{Integer. The maximum number of results to return in a single call.[optional]}

\item{NextToken}{Characters, The token for the next page of results[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{IncludeAllInstances}{Logical.   When \code{true}, includes the health status for all instances.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Describe Instance Status
}
\section{Filter}{


The filters.
\itemize{
\item \code{availability-zone} - The Availability Zone of the instance.
\item \code{event.code} - The code for the scheduled event (\code{instance-reboot}
\| \code{system-reboot} \| \code{system-maintenance} \| \code{instance-retirement}
\| \code{instance-stop}).
\item \code{event.description} - A description of the event.
\item \code{event.instance-event-id} - The ID of the event whose date and time
you are modifying.
\item \code{event.not-after} - The latest end time for the scheduled event (for
example, \verb{2014-09-15T17:15:20.000Z}).
\item \code{event.not-before} - The earliest start time for the scheduled event
(for example, \verb{2014-09-15T17:15:20.000Z}).
\item \code{event.not-before-deadline} - The deadline for starting the event
(for example, \verb{2014-09-15T17:15:20.000Z}).
\item \code{instance-state-code} - The code for the instance state, as a 16-bit
unsigned integer. The high byte is used for internal purposes and
should be ignored. The low byte is set based on the state
represented. The valid values are 0 (pending), 16 (running), 32
(shutting-down), 48 (terminated), 64 (stopping), and 80 (stopped).
\item \code{instance-state-name} - The state of the instance (\code{pending} \|
\code{running} \| \code{shutting-down} \| \code{terminated} \| \code{stopping} \|
\code{stopped}).
\item \code{instance-status.reachability} - Filters on instance status where
the name is \code{reachability} (\code{passed} \| \code{failed} \| \code{initializing}
\| \code{insufficient-data}).
\item \code{instance-status.status} - The status of the instance (\code{ok} \|
\code{impaired} \| \code{initializing} \| \code{insufficient-data} \|
\code{not-applicable}).
\item \code{system-status.reachability} - Filters on system status where the
name is \code{reachability} (\code{passed} \| \code{failed} \| \code{initializing} \|
\code{insufficient-data}).
\item \code{system-status.status} - The system status of the instance (\code{ok} \|
\code{impaired} \| \code{initializing} \| \code{insufficient-data} \|
\code{not-applicable}).
}
}

\section{InstanceId}{


The instance IDs.

Default: Describes all your instances.

Constraints: Maximum 100 explicitly specified instance IDs.
}

\section{MaxResults}{

The maximum number of results to return in a single
call. To retrieve the remaining results, make another call with the
returned \code{NextToken} value. This value can be between 5 and 1000. You
cannot specify this parameter and the instance IDs parameter in the same
call.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{IncludeAllInstances}{


When \code{true}, includes the health status for all instances. When \code{false},
includes the health status for running instances only.

Default: \code{false}
}

