% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_detach_volume}
\alias{ec2_detach_volume}
\title{Detach Volume}
\usage{
ec2_detach_volume(
  VolumeId,
  Device = NULL,
  Force = NULL,
  InstanceId = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{VolumeId}{String. The ID of the volume.}

\item{Device}{String. The device name.[optional]}

\item{Force}{Logical. Forces detachment if the previous detachment attempt did not occur cleanly (for example, logging into an instance, unmounting the volume, and detaching normally)....[optional]}

\item{InstanceId}{String. The ID of the instance.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Detach Volume
}
\section{VolumeId}{

The ID of the volume.
}

\section{Device}{

The
device name.
}

\section{Force}{

Forces detachment if the previous
detachment attempt did not occur cleanly (for example, logging into an
instance, unmounting the volume, and detaching normally). This option
can lead to data loss or a corrupted file system. Use this option only
as a last resort to detach a volume from a failed instance. The instance
won\'t have an opportunity to flush file system caches or file system
metadata. If you use this option, you must perform file system check and
repair procedures.
}

\section{InstanceId}{

The ID of the instance. If you
are detaching a Multi-Attach enabled volume, you must specify an
instance ID.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

