% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_disable_fast_snapshot_restores}
\alias{ec2_disable_fast_snapshot_restores}
\title{Disable Fast Snapshot Restores}
\usage{
ec2_disable_fast_snapshot_restores(
  AvailabilityZone,
  SourceSnapshotId,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{AvailabilityZone}{List. One or more Availability Zones. For example, \verb{us-east-2a}.}

\item{SourceSnapshotId}{List. The IDs of one or more snapshots. For example, \verb{snap-1234567890abcdef0}.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Disables fast snapshot restores for the specified
snapshots in the specified Availability
Zones.
}
\section{AvailabilityZone}{

One or more Availability
Zones. For example, \verb{us-east-2a}.
}

\section{SourceSnapshotId}{

The IDs of one or
more snapshots. For example,
\verb{snap-1234567890abcdef0}.
}

\section{DryRun}{

Checks whether you have
the required permissions for the action, without actually making the
request, and provides an error response. If you have the required
permissions, the error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

