% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_modify_hosts}
\alias{ec2_modify_hosts}
\title{Modify Hosts}
\usage{
ec2_modify_hosts(
  HostId,
  AutoPlacement = NULL,
  HostRecovery = NULL,
  InstanceType = NULL,
  InstanceFamily = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{HostId}{List. The IDs of the Dedicated Hosts to modify.}

\item{AutoPlacement}{String. Specify whether to enable or disable auto-placement.[optional]}

\item{HostRecovery}{String. Indicates whether to enable or disable host recovery for the Dedicated Host.[optional]}

\item{InstanceType}{String.   Specifies the instance type to be supported by the Dedicated Host.[optional]}

\item{InstanceFamily}{String.   Specifies the instance family to be supported by the Dedicated Host.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Modify Hosts
}
\section{HostId}{

The IDs
of the Dedicated Hosts to modify.
}

\section{AutoPlacement}{

Specify whether to
enable or disable auto-placement.
}

\section{HostRecovery}{

Indicates whether
to enable or disable host recovery for the Dedicated Host. For more
information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html}{Host recovery}
in the \emph{Amazon EC2 User Guide}.
}

\section{InstanceType}{


Specifies the instance type to be supported by the Dedicated Host.
Specify this parameter to modify a Dedicated Host to support only a
specific instance type.

If you want to modify a Dedicated Host to support multiple instance
types in its current instance family, omit this parameter and specify
\strong{InstanceFamily} instead. You cannot specify \strong{InstanceType} and
\strong{InstanceFamily} in the same request.
}

\section{InstanceFamily}{


Specifies the instance family to be supported by the Dedicated Host.
Specify this parameter to modify a Dedicated Host to support multiple
instance types within its current instance family.

If you want to modify a Dedicated Host to support a specific instance
type only, omit this parameter and specify \strong{InstanceType} instead. You
cannot specify \strong{InstanceFamily} and \strong{InstanceType} in the same
request.
}

