% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_register_transit_gateway_multicast_group_sources}
\alias{ec2_register_transit_gateway_multicast_group_sources}
\title{Register Transit Gateway Multicast Group Sources}
\usage{
ec2_register_transit_gateway_multicast_group_sources(
  TransitGatewayMulticastDomainId = NULL,
  GroupIpAddress = NULL,
  NetworkInterfaceIds = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{TransitGatewayMulticastDomainId}{String. The ID of the transit gateway multicast domain.[optional]}

\item{GroupIpAddress}{String. The IP address assigned to the transit gateway multicast group.[optional]}

\item{NetworkInterfaceIds}{List. The group sources\' network interface IDs to register with the transit gateway multicast group.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Register Transit Gateway Multicast Group Sources
}
\section{TransitGatewayMulticastDomainId}{

The ID of the transit
gateway multicast domain.
}

\section{GroupIpAddress}{

The IP address assigned to
the transit gateway multicast group.
}

\section{NetworkInterfaceIds}{

The group
sources\' network interface IDs to register with the transit gateway
multicast group.
}

\section{DryRun}{

Checks whether you have the
required permissions for the action, without actually making the
request, and provides an error response. If you have the required
permissions, the error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

