% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_run_instances}
\alias{ec2_run_instances}
\title{Run Instances}
\usage{
ec2_run_instances(
  MaxCount,
  MinCount,
  BlockDeviceMapping = NULL,
  ImageId = NULL,
  InstanceType = NULL,
  Ipv6AddressCount = NULL,
  Ipv6Address = NULL,
  KernelId = NULL,
  KeyName = NULL,
  Monitoring = NULL,
  Placement = NULL,
  RamdiskId = NULL,
  SecurityGroupId = NULL,
  SecurityGroup = NULL,
  SubnetId = NULL,
  UserData = NULL,
  AdditionalInfo = NULL,
  ClientToken = NULL,
  DisableApiTermination = NULL,
  DryRun = NULL,
  EbsOptimized = NULL,
  IamInstanceProfile = NULL,
  InstanceInitiatedShutdownBehavior = NULL,
  NetworkInterface = NULL,
  PrivateIpAddress = NULL,
  ElasticGpuSpecification = NULL,
  ElasticInferenceAccelerator = NULL,
  TagSpecification = NULL,
  LaunchTemplate = NULL,
  InstanceMarketOptions = NULL,
  CreditSpecification = NULL,
  CpuOptions = NULL,
  CapacityReservationSpecification = NULL,
  HibernationOptions = NULL,
  LicenseSpecification = NULL,
  MetadataOptions = NULL,
  EnclaveOptions = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{MaxCount}{Integer.   The maximum number of instances to launch.}

\item{MinCount}{Integer.   The minimum number of instances to launch.}

\item{BlockDeviceMapping}{List. The block device mapping entries.[optional]}

\item{ImageId}{String. The ID of the AMI.[optional]}

\item{InstanceType}{String.   The instance type.[optional]}

\item{Ipv6AddressCount}{Integer.   [EC2-VPC] The number of IPv6 addresses to associate with the primary network interface.[optional]}

\item{Ipv6Address}{List.   [EC2-VPC] The IPv6 addresses from the range of the subnet to associate with the primary network...[optional]}

\item{KernelId}{String.   The ID of the kernel.[optional]}

\item{KeyName}{String.   The name of the key pair.[optional]}

\item{Monitoring}{Object. Specifies whether detailed monitoring is enabled for the instance.[optional]}

\item{Placement}{Object. The placement for the instance.[optional]}

\item{RamdiskId}{String.   The ID of the RAM disk to select.[optional]}

\item{SecurityGroupId}{List.   The IDs of the security groups.[optional]}

\item{SecurityGroup}{List.   [EC2-Classic, default VPC] The names of the security groups.[optional]}

\item{SubnetId}{String.   [EC2-VPC] The ID of the subnet to launch the instance into.[optional]}

\item{UserData}{String. The user data to make available to the instance.[optional]}

\item{AdditionalInfo}{String. Reserved.[optional]}

\item{ClientToken}{String.   Unique, case-sensitive identifier you provide to ensure the idempotency of the request.[optional]}

\item{DisableApiTermination}{Logical.   If you set this parameter to \code{true}, you can\'t terminate the instance using the Amazon EC2 console,...[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{EbsOptimized}{Logical.   Indicates whether the instance is optimized for Amazon EBS I/O.[optional]}

\item{IamInstanceProfile}{Object. The name or Amazon Resource Name (ARN) of an IAM instance profile.[optional]}

\item{InstanceInitiatedShutdownBehavior}{String.   Indicates whether an instance stops or terminates when you initiate shutdown from the instance...[optional]}

\item{NetworkInterface}{List. The network interfaces to associate with the instance.[optional]}

\item{PrivateIpAddress}{String.   [EC2-VPC] The primary IPv4 address.[optional]}

\item{ElasticGpuSpecification}{List. An elastic GPU to associate with the instance.[optional]}

\item{ElasticInferenceAccelerator}{List.   An elastic inference accelerator to associate with the instance.[optional]}

\item{TagSpecification}{List. The tags to apply to the resources during launch.[optional]}

\item{LaunchTemplate}{Object. The launch template to use to launch the instances.[optional]}

\item{InstanceMarketOptions}{Object.   The market (purchasing) option for the instances.[optional]}

\item{CreditSpecification}{Object.   The credit option for CPU usage of the burstable performance instance.[optional]}

\item{CpuOptions}{Object. The CPU options for the instance.[optional]}

\item{CapacityReservationSpecification}{Object. Information about the Capacity Reservation targeting option.[optional]}

\item{HibernationOptions}{Object.   Indicates whether an instance is enabled for hibernation.[optional]}

\item{LicenseSpecification}{List. The license configurations.[optional]}

\item{MetadataOptions}{Object. The metadata options for the instance.[optional]}

\item{EnclaveOptions}{Object.   Indicates whether the instance is enabled for AWS Nitro Enclaves.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Run Instances
}
\section{MaxCount}{


The maximum number of instances to launch. If you specify more instances
than Amazon EC2 can launch in the target Availability Zone, Amazon EC2
launches the largest possible number of instances above \code{MinCount}.

Constraints: Between 1 and the maximum number you\'re allowed for the
specified instance type. For more information about the default limits,
and how to request an increase, see \href{https://aws.amazon.com/ec2/faqs/#How_many_instances_can_I_run_in_Amazon_EC2/}{How many instances can I run in Amazon EC2}
in the Amazon EC2 FAQ.
}

\section{MinCount}{


The minimum number of instances to launch. If you specify a minimum that
is more instances than Amazon EC2 can launch in the target Availability
Zone, Amazon EC2 launches no instances.

Constraints: Between 1 and the maximum number you\'re allowed for the
specified instance type. For more information about the default limits,
and how to request an increase, see \href{https://aws.amazon.com/ec2/faqs/#How_many_instances_can_I_run_in_Amazon_EC2/}{How many instances can I run in Amazon EC2}
in the Amazon EC2 General FAQ.
}

\section{BlockDeviceMapping}{

The block device mapping
entries.
}

\section{ImageId}{

The ID of the AMI. An AMI ID is required to
launch an instance and must be specified here or in a launch
template.
}

\section{InstanceType}{


The instance type. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html}{Instance types}
in the \emph{Amazon EC2 User Guide}.

Default: \code{m1.small}
}

\section{Ipv6AddressCount}{


[EC2-VPC] The number of IPv6 addresses to associate with the primary
network interface. Amazon EC2 chooses the IPv6 addresses from the range
of your subnet. You cannot specify this option and the option to assign
specific IPv6 addresses in the same request. You can specify this option
if you\'ve specified a minimum number of instances to launch.

You cannot specify this option and the network interfaces option in the
same request.
}

\section{Ipv6Address}{


[EC2-VPC] The IPv6 addresses from the range of the subnet to associate
with the primary network interface. You cannot specify this option and
the option to assign a number of IPv6 addresses in the same request. You
cannot specify this option if you\'ve specified a minimum number of
instances to launch.

You cannot specify this option and the network interfaces option in the
same request.
}

\section{KernelId}{


The ID of the kernel.

We recommend that you use PV-GRUB instead of kernels and RAM disks. For
more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html}{PV-GRUB}
in the \emph{Amazon EC2 User Guide}.
}

\section{KeyName}{


The name of the key pair. You can create a key pair using
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateKeyPair.html}{CreateKeyPair}
or
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportKeyPair.html}{ImportKeyPair}.

If you do not specify a key pair, you can\'t connect to the instance
unless you choose an AMI that is configured to allow users another way
to log in.
}

\section{Monitoring}{

Specifies whether detailed monitoring is enabled
for the instance.
}

\section{Placement}{

The placement for the
instance.
}

\section{RamdiskId}{


The ID of the RAM disk to select. Some kernels require additional
drivers at launch. Check the kernel requirements for information about
whether you need to specify a RAM disk. To find kernel requirements, go
to the AWS Resource Center and search for the kernel ID.

We recommend that you use PV-GRUB instead of kernels and RAM disks. For
more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html}{PV-GRUB}
in the \emph{Amazon EC2 User Guide}.
}

\section{SecurityGroupId}{


The IDs of the security groups. You can create a security group using
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSecurityGroup.html}{CreateSecurityGroup}.

If you specify a network interface, you must specify any security groups
as part of the network interface.
}

\section{SecurityGroup}{


[EC2-Classic, default VPC] The names of the security groups. For a
nondefault VPC, you must use security group IDs instead.

If you specify a network interface, you must specify any security groups
as part of the network interface.

Default: Amazon EC2 uses the default security group.
}

\section{SubnetId}{


[EC2-VPC] The ID of the subnet to launch the instance into.

If you specify a network interface, you must specify any subnets as part
of the network interface.
}

\section{UserData}{

The user data to make available to the instance.
For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/user-data.html}{Running commands on your Linux instance at launch}
(Linux) and \href{https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-metadata.html#instancedata-add-user-data}{Adding User Data}
(Windows). If you are using a command line tool, base64-encoding is
performed for you, and you can load the text from a file. Otherwise, you
must provide base64-encoded text. User data is limited to 16
KB.
}

\section{AdditionalInfo}{

Reserved.
}

\section{ClientToken}{


Unique, case-sensitive identifier you provide to ensure the idempotency
of the request. If you do not specify a client token, a randomly
generated token is used for the request to ensure idempotency.

For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{Ensuring Idempotency}.

Constraints: Maximum 64 ASCII characters
}

\section{DisableApiTermination}{


If you set this parameter to \code{true}, you can\'t terminate the instance
using the Amazon EC2 console, CLI, or API; otherwise, you can. To change
this attribute after launch, use
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceAttribute.html}{ModifyInstanceAttribute}.
Alternatively, if you set \code{InstanceInitiatedShutdownBehavior} to
\code{terminate}, you can terminate the instance by running the shutdown
command from the instance.

Default: \code{false}
}

\section{DryRun}{

Checks whether you have the required permissions
for the action, without actually making the request, and provides an
error response. If you have the required permissions, the error response
is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{EbsOptimized}{


Indicates whether the instance is optimized for Amazon EBS I/O. This
optimization provides dedicated throughput to Amazon EBS and an
optimized configuration stack to provide optimal Amazon EBS I/O
performance. This optimization isn\'t available with all instance types.
Additional usage charges apply when using an EBS-optimized instance.

Default: \code{false}
}

\section{IamInstanceProfile}{

The name or Amazon Resource Name (ARN) of an IAM
instance profile.
}

\section{InstanceInitiatedShutdownBehavior}{


Indicates whether an instance stops or terminates when you initiate
shutdown from the instance (using the operating system command for
system shutdown).

Default: \code{stop}
}

\section{NetworkInterface}{

The network interfaces to associate with the
instance. If you specify a network interface, you must specify any
security groups and subnets as part of the network
interface.
}

\section{PrivateIpAddress}{


[EC2-VPC] The primary IPv4 address. You must specify a value from the
IPv4 address range of the subnet.

Only one private IP address can be designated as primary. You can\'t
specify this option if you\'ve specified the option to designate a
private IP address as the primary IP address in a network interface
specification. You cannot specify this option if you\'re launching more
than one instance in the request.

You cannot specify this option and the network interfaces option in the
same request.
}

\section{ElasticGpuSpecification}{

An elastic GPU to associate with the instance. An
Elastic GPU is a GPU resource that you can attach to your Windows
instance to accelerate the graphics performance of your applications.
For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-graphics.html}{Amazon EC2 Elastic GPUs}
in the \emph{Amazon EC2 User Guide}.
}

\section{ElasticInferenceAccelerator}{


An elastic inference accelerator to associate with the instance. Elastic
inference accelerators are a resource you can attach to your Amazon EC2
instances to accelerate your Deep Learning (DL) inference workloads.

You cannot specify accelerators from different generations in the same
request.
}

\section{TagSpecification}{

The tags to apply to the resources during launch.
You can only tag instances and volumes on launch. The specified tags are
applied to all instances or volumes that are created during launch. To
tag a resource after it has been created, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html}{CreateTags}.
}

\section{LaunchTemplate}{

The
launch template to use to launch the instances. Any parameters that you
specify in RunInstances override the same parameters in the launch
template. You can specify either the name or ID of a launch template,
but not both.
}

\section{InstanceMarketOptions}{


The market (purchasing) option for the instances.

For RunInstances, persistent Spot Instance requests are only supported
when \strong{InstanceInterruptionBehavior} is set to either \code{hibernate} or
\code{stop}.
}

\section{CreditSpecification}{


The credit option for CPU usage of the burstable performance instance.
Valid values are \code{standard} and \code{unlimited}. To change this attribute
after launch, use
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceCreditSpecification.html}{ModifyInstanceCreditSpecification}.
For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html}{Burstable performance instances}
in the \emph{Amazon EC2 User Guide}.

Default: \code{standard} (T2 instances) or \code{unlimited} (T3/T3a instances)
}

\section{CpuOptions}{

The CPU options for the instance. For more
information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html}{Optimizing CPU options}
in the \emph{Amazon EC2 User Guide}.
}

\section{CapacityReservationSpecification}{

Information about
the Capacity Reservation targeting option. If you do not specify this
parameter, the instance\'s Capacity Reservation preference defaults to
\code{open}, which enables it to run in any open Capacity Reservation that
has matching attributes (instance type, platform, Availability
Zone).
}

\section{HibernationOptions}{


Indicates whether an instance is enabled for hibernation. For more
information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html}{Hibernate your instance}
in the \emph{Amazon EC2 User Guide}.

You can\'t enable hibernation and AWS Nitro Enclaves on the same
instance.
}

\section{LicenseSpecification}{

The license configurations.
}

\section{MetadataOptions}{

The
metadata options for the instance. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html}{Instance metadata and user data}.
}

\section{EnclaveOptions}{


Indicates whether the instance is enabled for AWS Nitro Enclaves. For
more information, see \href{https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave.html}{What is AWS Nitro Enclaves?}
in the \emph{AWS Nitro Enclaves User Guide}.

You can\'t enable AWS Nitro Enclaves and hibernation on the same
instance.
}

