% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_transit_gateway_connect_peer}
\alias{ec2_create_transit_gateway_connect_peer}
\title{Create Transit Gateway Connect Peer}
\usage{
ec2_create_transit_gateway_connect_peer(
  TransitGatewayAttachmentId,
  PeerAddress,
  InsideCidrBlocks,
  TransitGatewayAddress = NULL,
  BgpOptions = NULL,
  TagSpecification = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{TransitGatewayAttachmentId}{Character. The ID of the Connect attachment.}

\item{PeerAddress}{Character. The peer IP address (GRE outer IP address) on the appliance side of the Connect peer.}

\item{InsideCidrBlocks}{List. The range of inside IP addresses that are used for BGP peering.}

\item{TransitGatewayAddress}{Character. The peer IP address (GRE outer IP address) on the transit gateway side of the Connect peer, which...[optional]}

\item{BgpOptions}{Object. The BGP options for the Connect peer.[optional]}

\item{TagSpecification}{List. The tags to apply to the Connect peer.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Create Transit Gateway Connect Peer
}
\section{TransitGatewayAttachmentId}{

The ID of the Connect
attachment.
}

\section{PeerAddress}{

The peer IP address (GRE outer IP
address) on the appliance side of the Connect
peer.
}

\section{InsideCidrBlocks}{

The range of inside IP addresses that are used
for BGP peering. You must specify a size /29 IPv4 CIDR block from the
\verb{169.254.0.0/16} range. The first address from the range must be
configured on the appliance as the BGP IP address. You can also
optionally specify a size /125 IPv6 CIDR block from the \verb{fd00::/8}
range.
}

\section{TransitGatewayAddress}{

The peer IP address (GRE outer IP address) on
the transit gateway side of the Connect peer, which must be specified
from a transit gateway CIDR block. If not specified, Amazon
automatically assigns the first available IP address from the transit
gateway CIDR block.
}

\section{BgpOptions}{

The BGP options for the Connect
peer.
}

\section{TagSpecification}{

The tags to apply to the Connect
peer.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

