% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_vpc_endpoint_service_configuration}
\alias{ec2_create_vpc_endpoint_service_configuration}
\title{Create Vpc Endpoint Service Configuration}
\usage{
ec2_create_vpc_endpoint_service_configuration(
  DryRun = NULL,
  AcceptanceRequired = NULL,
  PrivateDnsName = NULL,
  NetworkLoadBalancerArn = NULL,
  GatewayLoadBalancerArn = NULL,
  ClientToken = NULL,
  TagSpecification = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{AcceptanceRequired}{Logical. Indicates whether requests from service consumers to create an endpoint to your service must be accepted....[optional]}

\item{PrivateDnsName}{Character. (Interface endpoint configuration) The private DNS name to assign to the VPC endpoint service.[optional]}

\item{NetworkLoadBalancerArn}{List. The Amazon Resource Names (ARNs) of one or more Network Load Balancers for your service.[optional]}

\item{GatewayLoadBalancerArn}{List. The Amazon Resource Names (ARNs) of one or more Gateway Load Balancers.[optional]}

\item{ClientToken}{Character. Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.[optional]}

\item{TagSpecification}{List. The tags to associate with the service.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Create Vpc Endpoint Service Configuration
}
\section{DryRun}{

Checks
whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.
}

\section{AcceptanceRequired}{

Indicates
whether requests from service consumers to create an endpoint to your
service must be accepted. To accept a request, use
AcceptVpcEndpointConnections.
}

\section{PrivateDnsName}{

(Interface endpoint
configuration) The private DNS name to assign to the VPC endpoint
service.
}

\section{NetworkLoadBalancerArn}{

The Amazon Resource Names (ARNs) of one or
more Network Load Balancers for your service.
}

\section{GatewayLoadBalancerArn}{

The
Amazon Resource Names (ARNs) of one or more Gateway Load
Balancers.
}

\section{ClientToken}{

Unique, case-sensitive identifier that
you provide to ensure the idempotency of the request. For more
information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html}{How to Ensure Idempotency}.
}

\section{TagSpecification}{

The
tags to associate with the service.
}

