% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_images}
\alias{ec2_describe_images}
\title{Describe Images}
\usage{
ec2_describe_images(
  ExecutableBy = NULL,
  Filter = NULL,
  ImageId = NULL,
  Owner = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{ExecutableBy}{List. Scopes the images by users with explicit launch permissions.[optional]}

\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{ImageId}{List.   The image IDs.  Default: Describes all images available to you.  [optional]}

\item{Owner}{List. Scopes the results to images with the specified owners.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Describe Images
}
\section{ExecutableBy}{

Scopes the
images by users with explicit launch permissions. Specify an AWS account
ID, \code{self} (the sender of the request), or \code{all} (public
AMIs).
}

\section{Filter}{


The filters.
\itemize{
\item \code{architecture} - The image architecture (\code{i386} \| \code{x86_64} \|
\code{arm64}).
\item \code{block-device-mapping.delete-on-termination} - A Boolean value that
indicates whether the Amazon EBS volume is deleted on instance
termination.
\item \code{block-device-mapping.device-name} - The device name specified in
the block device mapping (for example, \verb{/dev/sdh} or \code{xvdh}).
\item \code{block-device-mapping.snapshot-id} - The ID of the snapshot used for
the EBS volume.
\item \code{block-device-mapping.volume-size} - The volume size of the EBS
volume, in GiB.
\item \code{block-device-mapping.volume-type} - The volume type of the EBS
volume (\code{gp2} \| \code{io1} \| \code{io2} \| \code{st1 }\| \code{sc1} \| \code{standard}).
\item \code{block-device-mapping.encrypted} - A Boolean that indicates whether
the EBS volume is encrypted.
\item \code{description} - The description of the image (provided during image
creation).
\item \code{ena-support} - A Boolean that indicates whether enhanced networking
with ENA is enabled.
\item \code{hypervisor} - The hypervisor type (\code{ovm} \| \code{xen}).
\item \code{image-id} - The ID of the image.
\item \code{image-type} - The image type (\code{machine} \| \code{kernel} \| \code{ramdisk}).
\item \code{is-public} - A Boolean that indicates whether the image is public.
\item \code{kernel-id} - The kernel ID.
\item \code{manifest-location} - The location of the image manifest.
\item \code{name} - The name of the AMI (provided during image creation).
\item \code{owner-alias} - The owner alias (\code{amazon} \| \code{aws-marketplace}). The
valid aliases are defined in an Amazon-maintained list. This is not
the AWS account alias that can be set using the IAM console. We
recommend that you use the \strong{Owner} request parameter instead of
this filter.
\item \code{owner-id} - The AWS account ID of the owner. We recommend that you
use the \strong{Owner} request parameter instead of this filter.
\item \code{platform} - The platform. To only list Windows-based AMIs, use
\code{windows}.
\item \code{product-code} - The product code.
\item \code{product-code.type} - The type of the product code (\code{devpay} \|
\code{marketplace}).
\item \code{ramdisk-id} - The RAM disk ID.
\item \code{root-device-name} - The device name of the root device volume (for
example, \verb{/dev/sda1}).
\item \code{root-device-type} - The type of the root device volume (\code{ebs} \|
\code{instance-store}).
\item \code{state} - The state of the image (\code{available} \| \code{pending} \|
\code{failed}).
\item \code{state-reason-code} - The reason code for the state change.
\item \code{state-reason-message} - The message for the state change.
\item \code{sriov-net-support} - A value of \code{simple} indicates that enhanced
networking with the Intel 82599 VF interface is enabled.
\item \code{tag}:\ - The key/value combination of a tag assigned to the
resource. Use the tag key in the filter name and the tag value as
the filter value. For example, to find all resources that have a tag
with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for
the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
\item \code{virtualization-type} - The virtualization type (\code{paravirtual} \|
\code{hvm}).
}
}

\section{ImageId}{


The image IDs.

Default: Describes all images available to you.
}

\section{Owner}{

Scopes the results to images with the specified
owners. You can specify a combination of AWS account IDs, \code{self},
\code{amazon}, and \code{aws-marketplace}. If you omit this parameter, the results
include all images for which you have launch permissions, regardless of
ownership.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

