% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_spot_price_history}
\alias{ec2_describe_spot_price_history}
\title{Describe Spot Price History}
\usage{
ec2_describe_spot_price_history(
  Filter = NULL,
  AvailabilityZone = NULL,
  DryRun = NULL,
  EndTime = NULL,
  InstanceType = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  ProductDescription = NULL,
  StartTime = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{AvailabilityZone}{Character. Filters the results by the specified Availability Zone.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{EndTime}{Character. The date and time, up to the current date, from which to stop retrieving the price history data,...[optional]}

\item{InstanceType}{List. Filters the results by the specified instance types.[optional]}

\item{MaxResults}{Integer. The maximum number of results to return in a single call.[optional]}

\item{NextToken}{Characters. The token for the next page of results[optional]}

\item{ProductDescription}{List. Filters the results by the specified basic product descriptions.[optional]}

\item{StartTime}{Character. The date and time, up to the past 90 days, from which to start retrieving the price history data,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Describe Spot Price History
}
\section{Filter}{


One or more filters.
\itemize{
\item \code{availability-zone} - The Availability Zone for which prices should
be returned.
\item \code{instance-type} - The type of instance (for example, \code{m3.medium}).
\item \code{product-description} - The product description for the Spot price
(\code{Linux/UNIX} \| \verb{Red Hat Enterprise Linux} \| \verb{SUSE Linux} \|
\code{Windows} \| \verb{Linux/UNIX (Amazon VPC)} \|
\verb{Red Hat Enterprise Linux (Amazon VPC)} \| \verb{SUSE Linux (Amazon VPC)}
\| \verb{Windows (Amazon VPC)}).
\item \code{spot-price} - The Spot price. The value must match exactly (or use
wildcards; greater than or less than comparison is not supported).
\item \code{timestamp} - The time stamp of the Spot price history, in UTC
format (for example, \emph{YYYY}-\emph{MM}-\emph{DD}T\emph{HH}:\emph{MM}:\emph{SS}Z). You can use
wildcards (\* and ?). Greater than or less than comparison is not
supported.
}
}

\section{AvailabilityZone}{

Filters the results by the specified Availability
Zone.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{EndTime}{

The date and time, up to
the current date, from which to stop retrieving the price history data,
in UTC format (for example,
\emph{YYYY}-\emph{MM}-\emph{DD}T\emph{HH}:\emph{MM}:\emph{SS}Z).
}

\section{InstanceType}{

Filters the
results by the specified instance types.
}

\section{MaxResults}{

The maximum
number of results to return in a single call. Specify a value between 1
and 1000. The default value is 1000. To retrieve the remaining results,
make another call with the returned \code{NextToken}
value.
}

\section{ProductDescription}{

Filters the results by the specified basic
product descriptions.
}

\section{StartTime}{

The date and time, up to the
past 90 days, from which to start retrieving the price history data, in
UTC format (for example,
\emph{YYYY}-\emph{MM}-\emph{DD}T\emph{HH}:\emph{MM}:\emph{SS}Z).
}

