% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roles.R
\name{create_role}
\alias{create_role}
\alias{delete_role}
\alias{add_profile_role}
\alias{remove_profile_role}
\alias{list_roles}
\title{Manage IAM Roles}
\usage{
create_role(role, policy, path, ...)

delete_role(role, ...)

add_profile_role(role, profile, ...)

remove_profile_role(role, profile, ...)

list_roles(n, marker, path, ...)
}
\arguments{
\item{role}{A character string containing a role name or an object of class \dQuote{iam_role}.}

\item{policy}{\dots}

\item{path}{A character string specifying a path prefix in which to locate user(s), role(s), etc. See \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html}{Reference Identifiers} on the AWS Documentation for more information.}

\item{\dots}{Additional arguments passed to \code{\link{iamHTTP}}.}

\item{profile}{A character string specifying the name for the profile, or an object of class \dQuote{iam_instance_profile}.}

\item{n}{An integer specifying the number of responses to return.}

\item{marker}{A character string specifying a marker (from a previous response) to use in paginating results}
}
\value{
\code{create_role} and \code{get_role} return objects of class \dQuote{iam_role}. \code{update_role} and \code{delete_role} return a logical \code{TRUE} (if successful) or an error. \code{list_roles} returns a list of IAM role objects.
}
\description{
Retrieve, create, update, and delete IAM Roles
}
\seealso{
\code{\link{create_user}}, \code{\link{create_group}},
}
