% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datastore.R
\name{upload_files_to_datastore}
\alias{upload_files_to_datastore}
\title{Upload files to the Azure storage a datastore points to}
\usage{
upload_files_to_datastore(datastore, files, relative_root = NULL,
  target_path = NULL, overwrite = FALSE, show_progress = TRUE)
}
\arguments{
\item{datastore}{The \code{AzureBlobDatastore} or \code{AzureFileDatastore} object.}

\item{files}{A character vector of the absolute path to files to upload.}

\item{relative_root}{A string of the base path from which is used to
determine the path of the files in the Azure storage. For example, if
we upload \code{/path/to/file.txt}, and we define the base path to be \code{/path},
when \code{file.txt} is uploaded to the blob storage or file share, it will
have the path of \code{/to/file.txt}. If \code{target_path} is also given, then it
will be used as the prefix for the derived path from above. The base path
must be a common path of all of the files, otherwise an exception will be
thrown.}

\item{target_path}{A string of the location in the blob container or file
share to upload the data to. Defaults to \code{NULL}, in which case the data is
uploaded to the root.}

\item{overwrite}{If \code{TRUE}, overwrites any existing data at \code{target_path}.}

\item{show_progress}{If \code{TRUE}, show progress of upload in the console.}
}
\value{
The \code{DataReference} object for the target path uploaded.
}
\description{
Upload the data from the local file system to the Azure storage that the
datastore points to.
}
