% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/master_sound_file.R
\name{master_sound_file}
\alias{master_sound_file}
\title{Create a master sound file}
\usage{
master_sound_file(X, file.name, dest.path = NULL, overwrite = FALSE, delay = 1, 
gap.duration = 1, amp.marker = 2, flim = c(0, 4), cex = 14)
}
\arguments{
\item{X}{object of class 'extended_selection_table' created by the function \code{\link[warbleR]{selection_table}} from the warbleR package. The object must include the following additional columns: 'bottom.freq' and 'top.freq'.}

\item{file.name}{Character string indicating the name of the sound file.}

\item{dest.path}{Character string containing the directory path where the sound file will be saved.
If \code{NULL} (default) then the current working directory will be used instead.}

\item{overwrite}{Logical argument to determine if the function will overwrite any existing sound file with the same file name. Default is \code{FALSE}.}

\item{delay}{Numeric vector of length 1 to control the duration (in s) of a silence gap at the beginning (and at the end) of the sound file. This can be useful to allow some time at the start of the playback experiment. Default is 1.}

\item{gap.duration}{Numeric vector of length 1 to control the duration (in s) of silence gaps to be placed in between signals. Default is 1 s.}

\item{amp.marker}{Numeric vector of length 1 to use as a constant to amplify markers amplitude. This is useful to increase the amplitude of markers in relation to those of signals, so it is picked up at further distances. Default is 2.}

\item{flim}{Numeric vector of length 2 to control the frequency range in which the markers would be found. If \code{NULL} markers would be display across the whole frequency range. Default is c(0, 4).}

\item{cex}{Numeric vector of length 1 indicating the font size for the start and end markers. Default is 14.}
}
\value{
Extended selection table similar to input data, but includes a new column (cross.correlation)
with the spectrogram cross-correlation coefficients.
}
\description{
\code{master_sound_file} creates a master sound file to be used in playback experiments related to sound degradation.
}
\details{
The function is intended to simplify the creation of master sound files for playback experiments in signal degradation studies. The function takes the wave objects from extended selection tables and concatenate them in a single sound file. The function also adds acoustic markers at the start and end of the playback that can be used to time-sync re-recorded signals to facilitate the streamlining of degradation quantification.
}
\examples{
{
# load example data from warbleR
data(list = c("Phae.long1", "Phae.long2", "Phae.long3", "Phae.long4", 
"lbh_selec_table"))

# save sound files to temporary folder
writeWave(Phae.long1, file.path(tempdir(), "Phae.long1.wav"))
writeWave(Phae.long2, file.path(tempdir(), "Phae.long2.wav"))
writeWave(Phae.long3, file.path(tempdir(), "Phae.long3.wav"))
writeWave(Phae.long4, file.path(tempdir(), "Phae.long4.wav"))

# make an extended selection table
est <- selection_table(X = lbh_selec_table, extended = TRUE, confirm.extended = FALSE, 
path = tempdir())

# create master sound file
master.sel.tab <- master_sound_file(X = est, file.name = "example_master", 
dest.path = tempdir(), gap.duration = 0.3)

# the following code exports the selection table to Raven using Rraven package
# Rraven::exp_raven(master.sel.tab, path = tempdir(), file.name = "example_master_selection_table")
}

}
\references{
{
Araya-Salas, M. (2020). baRulho: baRulho: quantifying habitat-induced degradation of (animal) acoustic signals in R. R package version 1.0.2
}
}
\seealso{
\code{\link[Rraven]{exp_raven}}
}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr})
}
