% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tail_to_signal_ratio.R
\name{tail_to_signal_ratio}
\alias{tail_to_signal_ratio}
\title{Measure reverberations as tail-to-signal ratio}
\usage{
tail_to_signal_ratio(X, mar, parallel = 1, pb = TRUE,  type = 1, 
bp = 'freq.range', output = "est", hop.size = 1, wl = NULL)
}
\arguments{
\item{X}{object of class 'extended_selection_table' created by the function \code{\link[warbleR]{selection_table}} from the warbleR package.}

\item{mar}{numeric vector of length 1. Specifies the margins adjacent to
the start and end points of selection over which to measure ambient noise.}

\item{parallel}{Numeric vector of length 1. Controls whether parallel computing is applied by specifying the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{pb}{Logical argument to control if progress bar is shown. Default is \code{TRUE}.}

\item{type}{Numeric. Determine the formula to be used to calculate the tail-to-signal ratio (S = signal, T = tail, N = background noise): 
\itemize{
\item \code{1}: ratio of T amplitude envelope quadratic mean to S amplitude envelope quadratic mean
 (\code{rms(env(T))/rms(env(S))}) as described by Dabelsteen et al. (1993).
\item \code{2}: ratio of T amplitude envelope quadratic mean to N amplitude envelope quadratic mean (\code{rms(env(T))/rms(env(N))}). N is measure in the margin right before the signal. So type 2 actually measures tail-to-noise ratio.
}}

\item{bp}{Numeric vector of length 2 giving the lower and upper limits of a frequency bandpass filter (in kHz). Alternatively, when set to 'freq.range' (default), which will make the function use the 'bottom.freq' and 'top.freq' as the bandpass range.}

\item{output}{Character vector of length 1 to determine if an extended selection table ('est', default) or a data frame ('data.frame').}

\item{hop.size}{A numeric vector of length 1 specifying the time window duration (in ms). Default is 1 ms, which is equivalent to ~45 wl for a 44.1 kHz sampling rate. Ignored if 'wl' is supplied.}

\item{wl}{A numeric vector of length 1 specifying the window length of the spectrogram, default 
is NULL. Ignored if \code{bp = NULL}. If supplied, 'hop.size' is ignored.
Note that lower values will increase time resolution, which is more important for amplitude ratio calculations.}
}
\value{
Extended selection table similar to input data, but also includes a new column (tail.to.signal.ratio)
with the tail-to-signal ratio values.
}
\description{
\code{tail_to_signal_ratio} measures reverberations as tail-to-signal ratio of signals referenced in an extended selection table.
}
\details{
Tail-to-signal ratio (TSR) measures ratio of energy in the tail of reverberations to energy in the signal. A general margin in which reverberation tail will be measured must be specified. The function will measure TSR within the supplied frequency range (e.g. bandpass) of the reference signal ('bottom.freq' and 'top.freq' columns in 'X'). Two methods for calculating reverberations are provided (see 'type' argument). Note that 'type' 2 is not equivalent to the original description of TSR in Dabelsteen et al. (1993) and  is better referred to as tail-to-noise ratio.
}
\examples{
{
# load example data
data("playback_est")

 # remove noise selections
 pe <- playback_est[playback_est$signal.type != "ambient", ]
 
 # using margin for noise of 0.01
 tail_to_signal_ratio(X = pe, mar = 0.01, bp = NULL)
 
 # tail-to-noise ratio (type 2)
 tail_to_signal_ratio(X = playback_est, mar = 0.01, type = 2)
}

}
\references{
{
Araya-Salas, M. (2020). baRulho: baRulho: quantifying habitat-induced degradation of (animal) acoustic signals in R. R package version 1.0.2

Dabelsteen, T., Larsen, O. N., & Pedersen, S. B. (1993). Habitat-induced degradation of sound signals: Quantifying the effects of communication sounds and bird location on blur ratio, excess attenuation, and signal-to-noise ratio in blackbird song. The Journal of the Acoustical Society of America, 93(4), 2206.

Darden, SK, Pedersen SB, Larsen ON, & Dabelsteen T. (2008). Sound transmission at ground level in a short-grass prairie habitat and its implications for long-range communication in the swift fox *Vulpes velox*. The Journal of the Acoustical Society of America, 124(2), 758-766.

}
}
\seealso{
\code{\link{excess_attenuation}}
}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr})
}
