
#' babette: A package for Bayesian phylogenetics.
#'
#' 'babette' provides for an alternative workflow of using
#' the popular phylogenetics tool 'BEAST2', including
#' it peripheral tools. From an alignment and
#' inference model, a posterior of jointly estimated
#' phylogenies and parameter estimates is generated.
#'
#' @examples
#' if (beautier::is_on_ci() && is_beast2_installed()) {
#'   beastier::remove_beaustier_folders()
#'   beastier::check_empty_beaustier_folders()
#'
#'   inference_model <- create_test_inference_model()
#'   beast2_options <- create_beast2_options()
#'
#'   bbt_run_from_model(
#'     fasta_filename = get_babette_path("anthus_aco.fas"),
#'     inference_model = inference_model,
#'     beast2_options = beast2_options
#'   )
#'
#'   # Clean up temporary files created by babette
#'   bbt_delete_temp_files(
#'     inference_model = inference_model,
#'     beast2_options = beast2_options
#'   )
#'   beastier::remove_beaustier_folders()
#'   beastier::check_empty_beaustier_folders()
#' }
#' beastier::remove_beaustier_folders()
#' @seealso
#' Use \link{bbt_self_test} to do verify \link{babette} is installed
#' correctly.\cr
#'
#' These are packages associated with 'babette':
#' \itemize{
#'   \item{
#'     '\link[beautier]{beautier}' creates 'BEAST2' input files.
#'   }
#'   \item{
#'     '\link[beastier]{beastier}' runs 'BEAST2'.
#'   }
#'   \item{
#'     '\link[mauricer]{mauricer}' does 'BEAST2' package management.
#'   }
#'   \item{
#'     '\link[tracerer]{tracerer}' parses 'BEAST2' output files.
#'   }
#' }
#' @docType package
#' @author Richèl J.C. Bilderbeek
#' @name babette
#' @note the imports are created by script 'scripts/create_imports.R'
#' @importFrom beautier are_clock_models
#' @importFrom beautier are_equal_mcmcs
#' @importFrom beautier are_equal_screenlogs
#' @importFrom beautier are_equal_tracelogs
#' @importFrom beautier are_equal_treelogs
#' @importFrom beautier are_equal_xml_files
#' @importFrom beautier are_equal_xml_lines
#' @importFrom beautier are_equivalent_xml_files
#' @importFrom beautier are_equivalent_xml_lines
#' @importFrom beautier are_equivalent_xml_lines_all
#' @importFrom beautier are_equivalent_xml_lines_loggers
#' @importFrom beautier are_equivalent_xml_lines_operators
#' @importFrom beautier are_equivalent_xml_lines_section
#' @importFrom beautier are_fasta_filenames
#' @importFrom beautier are_ids
#' @importFrom beautier are_init_clock_models
#' @importFrom beautier are_init_mrca_priors
#' @importFrom beautier are_init_site_models
#' @importFrom beautier are_init_tree_priors
#' @importFrom beautier are_mrca_align_ids_in_fasta
#' @importFrom beautier are_mrca_priors
#' @importFrom beautier are_mrca_taxon_names_in_fasta
#' @importFrom beautier are_rln_clock_models
#' @importFrom beautier are_site_models
#' @importFrom beautier are_tree_priors
#' @importFrom beautier check_alignment_id
#' @importFrom beautier check_beauti_options
#' @importFrom beautier check_clock_model
#' @importFrom beautier check_clock_models
#' @importFrom beautier check_empty_beautier_folder
#' @importFrom beautier check_file_and_model_agree
#' @importFrom beautier check_file_exists
#' @importFrom beautier check_filename
#' @importFrom beautier check_gamma_site_model
#' @importFrom beautier check_gamma_site_model_names
#' @importFrom beautier check_gtr_site_model
#' @importFrom beautier check_gtr_site_model_names
#' @importFrom beautier check_inference_model
#' @importFrom beautier check_inference_models
#' @importFrom beautier check_is_monophyletic
#' @importFrom beautier check_log_mode
#' @importFrom beautier check_log_sort
#' @importFrom beautier check_mcmc
#' @importFrom beautier check_mcmc_list_element_names
#' @importFrom beautier check_mcmc_nested_sampling
#' @importFrom beautier check_mcmc_values
#' @importFrom beautier check_mrca_prior
#' @importFrom beautier check_mrca_prior_name
#' @importFrom beautier check_mrca_prior_names
#' @importFrom beautier check_mrca_prior_taxa_names
#' @importFrom beautier check_nested_sampling_mcmc
#' @importFrom beautier check_ns_mcmc
#' @importFrom beautier check_param
#' @importFrom beautier check_param_names
#' @importFrom beautier check_param_types
#' @importFrom beautier check_phylogeny
#' @importFrom beautier check_rename_fun
#' @importFrom beautier check_rln_clock_model
#' @importFrom beautier check_screenlog
#' @importFrom beautier check_screenlog_names
#' @importFrom beautier check_screenlog_values
#' @importFrom beautier check_site_model
#' @importFrom beautier check_site_model_names
#' @importFrom beautier check_site_model_types
#' @importFrom beautier check_site_models
#' @importFrom beautier check_store_every
#' @importFrom beautier check_strict_clock_model
#' @importFrom beautier check_tn93_site_model
#' @importFrom beautier check_tn93_site_model_names
#' @importFrom beautier check_tracelog
#' @importFrom beautier check_tracelog_names
#' @importFrom beautier check_tracelog_values
#' @importFrom beautier check_tree_prior
#' @importFrom beautier check_tree_priors
#' @importFrom beautier check_treelog
#' @importFrom beautier check_treelog_names
#' @importFrom beautier check_treelog_values
#' @importFrom beautier compare_lines
#' @importFrom beautier count_trailing_spaces
#' @importFrom beautier create_alpha_param
#' @importFrom beautier create_bd_tree_prior
#' @importFrom beautier create_beast2_beast_xml
#' @importFrom beautier create_beast2_input
#' @importFrom beautier create_beast2_input_beast
#' @importFrom beautier create_beast2_input_data
#' @importFrom beautier create_beast2_input_data_sequences
#' @importFrom beautier create_beast2_input_distr
#' @importFrom beautier create_beast2_input_distr_lh
#' @importFrom beautier create_beast2_input_distr_prior
#' @importFrom beautier create_beast2_input_file
#' @importFrom beautier create_beast2_input_file_from_model
#' @importFrom beautier create_beast2_input_from_model
#' @importFrom beautier create_beast2_input_init
#' @importFrom beautier create_beast2_input_map
#' @importFrom beautier create_beast2_input_operators
#' @importFrom beautier create_beast2_input_run
#' @importFrom beautier create_beast2_input_state
#' @importFrom beautier create_beauti_options
#' @importFrom beautier create_beauti_options_v2_4
#' @importFrom beautier create_beauti_options_v2_6
#' @importFrom beautier create_beautier_tempfolder
#' @importFrom beautier create_beta_distr
#' @importFrom beautier create_beta_param
#' @importFrom beautier create_branch_rate_model_rln_xml
#' @importFrom beautier create_branch_rate_model_sc_xml
#' @importFrom beautier create_branch_rate_model_stuff_xml
#' @importFrom beautier create_branch_rate_model_xml
#' @importFrom beautier create_cbs_tree_prior
#' @importFrom beautier create_ccp_tree_prior
#' @importFrom beautier create_cep_tree_prior
#' @importFrom beautier create_clock_model
#' @importFrom beautier create_clock_model_from_name
#' @importFrom beautier create_clock_model_rln
#' @importFrom beautier create_clock_model_strict
#' @importFrom beautier create_clock_models
#' @importFrom beautier create_clock_models_from_names
#' @importFrom beautier create_clock_rate_param
#' @importFrom beautier create_clock_rate_state_node_parameter_xml
#' @importFrom beautier create_data_xml
#' @importFrom beautier create_distr
#' @importFrom beautier create_distr_beta
#' @importFrom beautier create_distr_exp
#' @importFrom beautier create_distr_gamma
#' @importFrom beautier create_distr_inv_gamma
#' @importFrom beautier create_distr_laplace
#' @importFrom beautier create_distr_log_normal
#' @importFrom beautier create_distr_normal
#' @importFrom beautier create_distr_one_div_x
#' @importFrom beautier create_distr_poisson
#' @importFrom beautier create_distr_uniform
#' @importFrom beautier create_exp_distr
#' @importFrom beautier create_gamma_distr
#' @importFrom beautier create_gamma_site_model
#' @importFrom beautier create_gtr_site_model
#' @importFrom beautier create_gtr_subst_model_xml
#' @importFrom beautier create_hky_site_model
#' @importFrom beautier create_hky_subst_model_xml
#' @importFrom beautier create_inference_model
#' @importFrom beautier create_inv_gamma_distr
#' @importFrom beautier create_jc69_site_model
#' @importFrom beautier create_jc69_subst_model_xml
#' @importFrom beautier create_kappa_1_param
#' @importFrom beautier create_kappa_2_param
#' @importFrom beautier create_lambda_param
#' @importFrom beautier create_laplace_distr
#' @importFrom beautier create_log_normal_distr
#' @importFrom beautier create_loggers_xml
#' @importFrom beautier create_m_param
#' @importFrom beautier create_mcmc
#' @importFrom beautier create_mcmc_nested_sampling
#' @importFrom beautier create_mean_param
#' @importFrom beautier create_mrca_prior
#' @importFrom beautier create_mu_param
#' @importFrom beautier create_normal_distr
#' @importFrom beautier create_ns_inference_model
#' @importFrom beautier create_ns_mcmc
#' @importFrom beautier create_one_div_x_distr
#' @importFrom beautier create_param
#' @importFrom beautier create_param_alpha
#' @importFrom beautier create_param_beta
#' @importFrom beautier create_param_clock_rate
#' @importFrom beautier create_param_kappa_1
#' @importFrom beautier create_param_kappa_2
#' @importFrom beautier create_param_lambda
#' @importFrom beautier create_param_m
#' @importFrom beautier create_param_mean
#' @importFrom beautier create_param_mu
#' @importFrom beautier create_param_rate_ac
#' @importFrom beautier create_param_rate_ag
#' @importFrom beautier create_param_rate_at
#' @importFrom beautier create_param_rate_cg
#' @importFrom beautier create_param_rate_ct
#' @importFrom beautier create_param_rate_gt
#' @importFrom beautier create_param_s
#' @importFrom beautier create_param_scale
#' @importFrom beautier create_param_sigma
#' @importFrom beautier create_poisson_distr
#' @importFrom beautier create_rate_ac_param
#' @importFrom beautier create_rate_ag_param
#' @importFrom beautier create_rate_at_param
#' @importFrom beautier create_rate_categories_state_node_xml
#' @importFrom beautier create_rate_cg_param
#' @importFrom beautier create_rate_ct_param
#' @importFrom beautier create_rate_gt_param
#' @importFrom beautier create_rln_clock_model
#' @importFrom beautier create_s_param
#' @importFrom beautier create_scale_param
#' @importFrom beautier create_screenlog
#' @importFrom beautier create_screenlog_xml
#' @importFrom beautier create_sigma_param
#' @importFrom beautier create_site_model
#' @importFrom beautier create_site_model_from_name
#' @importFrom beautier create_site_model_gtr
#' @importFrom beautier create_site_model_hky
#' @importFrom beautier create_site_model_jc69
#' @importFrom beautier create_site_model_parameters_xml
#' @importFrom beautier create_site_model_tn93
#' @importFrom beautier create_site_model_xml
#' @importFrom beautier create_site_models
#' @importFrom beautier create_site_models_from_names
#' @importFrom beautier create_strict_clock_model
#' @importFrom beautier create_strict_clock_rate_scaler_operator_xml
#' @importFrom beautier create_subst_model_xml
#' @importFrom beautier create_temp_screenlog_filename
#' @importFrom beautier create_temp_tracelog_filename
#' @importFrom beautier create_temp_treelog_filename
#' @importFrom beautier create_test_inference_model
#' @importFrom beautier create_test_mcmc
#' @importFrom beautier create_test_ns_inference_model
#' @importFrom beautier create_test_ns_mcmc
#' @importFrom beautier create_test_screenlog
#' @importFrom beautier create_test_tracelog
#' @importFrom beautier create_test_treelog
#' @importFrom beautier create_tn93_site_model
#' @importFrom beautier create_tn93_subst_model_xml
#' @importFrom beautier create_tracelog
#' @importFrom beautier create_tracelog_xml
#' @importFrom beautier create_trait_set_string
#' @importFrom beautier create_tree_likelihood_distr_xml
#' @importFrom beautier create_tree_prior
#' @importFrom beautier create_tree_prior_bd
#' @importFrom beautier create_tree_prior_cbs
#' @importFrom beautier create_tree_prior_ccp
#' @importFrom beautier create_tree_prior_cep
#' @importFrom beautier create_tree_prior_yule
#' @importFrom beautier create_tree_priors
#' @importFrom beautier create_treelog
#' @importFrom beautier create_treelog_xml
#' @importFrom beautier create_ucld_mean_state_node_param_xml
#' @importFrom beautier create_ucld_stdev_state_node_param_xml
#' @importFrom beautier create_uniform_distr
#' @importFrom beautier create_xml_declaration
#' @importFrom beautier create_yule_tree_prior
#' @importFrom beautier extract_xml_loggers_from_lines
#' @importFrom beautier extract_xml_operators_from_lines
#' @importFrom beautier extract_xml_section_from_lines
#' @importFrom beautier fasta_file_to_sequences
#' @importFrom beautier find_clock_model
#' @importFrom beautier find_first_regex_line
#' @importFrom beautier find_first_xml_opening_tag_line
#' @importFrom beautier find_last_regex_line
#' @importFrom beautier find_last_xml_closing_tag_line
#' @importFrom beautier get_alignment_id
#' @importFrom beautier get_alignment_ids
#' @importFrom beautier get_alignment_ids_from_fasta_filenames
#' @importFrom beautier get_beautier_folder
#' @importFrom beautier get_beautier_path
#' @importFrom beautier get_beautier_paths
#' @importFrom beautier get_beautier_tempfilename
#' @importFrom beautier get_clock_model_name
#' @importFrom beautier get_clock_model_names
#' @importFrom beautier get_clock_models_ids
#' @importFrom beautier get_crown_age
#' @importFrom beautier get_distr_n_params
#' @importFrom beautier get_distr_names
#' @importFrom beautier get_fasta_filename
#' @importFrom beautier get_file_base_sans_ext
#' @importFrom beautier get_freq_equilibrium_names
#' @importFrom beautier get_gamma_site_model_n_distrs
#' @importFrom beautier get_gamma_site_model_n_params
#' @importFrom beautier get_has_non_strict_clock_model
#' @importFrom beautier get_inference_model_filenames
#' @importFrom beautier get_log_modes
#' @importFrom beautier get_log_sorts
#' @importFrom beautier get_mcmc_filenames
#' @importFrom beautier get_n_taxa
#' @importFrom beautier get_operator_id_pre
#' @importFrom beautier get_param_names
#' @importFrom beautier get_remove_dir_fun
#' @importFrom beautier get_remove_hex_fun
#' @importFrom beautier get_replace_dir_fun
#' @importFrom beautier get_site_model_n_distrs
#' @importFrom beautier get_site_model_n_params
#' @importFrom beautier get_site_model_names
#' @importFrom beautier get_site_models_n_distrs
#' @importFrom beautier get_site_models_n_params
#' @importFrom beautier get_taxa_names
#' @importFrom beautier get_tree_prior_n_distrs
#' @importFrom beautier get_tree_prior_n_params
#' @importFrom beautier get_tree_prior_names
#' @importFrom beautier get_tree_priors_n_distrs
#' @importFrom beautier get_tree_priors_n_params
#' @importFrom beautier get_xml_closing_tag
#' @importFrom beautier get_xml_opening_tag
#' @importFrom beautier has_mrca_prior
#' @importFrom beautier has_mrca_prior_with_distr
#' @importFrom beautier has_rln_clock_model
#' @importFrom beautier has_strict_clock_model
#' @importFrom beautier has_tip_dating
#' @importFrom beautier has_xml_closing_tag
#' @importFrom beautier has_xml_opening_tag
#' @importFrom beautier has_xml_short_closing_tag
#' @importFrom beautier indent
#' @importFrom beautier is_alpha_param
#' @importFrom beautier is_bd_tree_prior
#' @importFrom beautier is_beauti_options
#' @importFrom beautier is_beta_distr
#' @importFrom beautier is_beta_param
#' @importFrom beautier is_cbs_tree_prior
#' @importFrom beautier is_ccp_tree_prior
#' @importFrom beautier is_cep_tree_prior
#' @importFrom beautier is_clock_model
#' @importFrom beautier is_clock_model_name
#' @importFrom beautier is_clock_rate_param
#' @importFrom beautier is_default_mcmc
#' @importFrom beautier is_distr
#' @importFrom beautier is_distr_name
#' @importFrom beautier is_exp_distr
#' @importFrom beautier is_freq_equilibrium_name
#' @importFrom beautier is_gamma_distr
#' @importFrom beautier is_gamma_site_model
#' @importFrom beautier is_gtr_site_model
#' @importFrom beautier is_hky_site_model
#' @importFrom beautier is_id
#' @importFrom beautier is_in_patterns
#' @importFrom beautier is_inference_model
#' @importFrom beautier is_init_bd_tree_prior
#' @importFrom beautier is_init_beta_distr
#' @importFrom beautier is_init_cbs_tree_prior
#' @importFrom beautier is_init_ccp_tree_prior
#' @importFrom beautier is_init_cep_tree_prior
#' @importFrom beautier is_init_clock_model
#' @importFrom beautier is_init_distr
#' @importFrom beautier is_init_exp_distr
#' @importFrom beautier is_init_gamma_distr
#' @importFrom beautier is_init_gamma_site_model
#' @importFrom beautier is_init_gtr_site_model
#' @importFrom beautier is_init_hky_site_model
#' @importFrom beautier is_init_inv_gamma_distr
#' @importFrom beautier is_init_jc69_site_model
#' @importFrom beautier is_init_laplace_distr
#' @importFrom beautier is_init_log_normal_distr
#' @importFrom beautier is_init_mrca_prior
#' @importFrom beautier is_init_normal_distr
#' @importFrom beautier is_init_one_div_x_distr
#' @importFrom beautier is_init_param
#' @importFrom beautier is_init_poisson_distr
#' @importFrom beautier is_init_rln_clock_model
#' @importFrom beautier is_init_site_model
#' @importFrom beautier is_init_strict_clock_model
#' @importFrom beautier is_init_tn93_site_model
#' @importFrom beautier is_init_tree_prior
#' @importFrom beautier is_init_uniform_distr
#' @importFrom beautier is_init_yule_tree_prior
#' @importFrom beautier is_inv_gamma_distr
#' @importFrom beautier is_jc69_site_model
#' @importFrom beautier is_kappa_1_param
#' @importFrom beautier is_kappa_2_param
#' @importFrom beautier is_lambda_param
#' @importFrom beautier is_laplace_distr
#' @importFrom beautier is_log_normal_distr
#' @importFrom beautier is_m_param
#' @importFrom beautier is_mcmc
#' @importFrom beautier is_mcmc_nested_sampling
#' @importFrom beautier is_mean_param
#' @importFrom beautier is_mrca_align_id_in_fasta
#' @importFrom beautier is_mrca_align_ids_in_fastas
#' @importFrom beautier is_mrca_prior
#' @importFrom beautier is_mrca_prior_with_distr
#' @importFrom beautier is_mu_param
#' @importFrom beautier is_nested_sampling_mcmc
#' @importFrom beautier is_normal_distr
#' @importFrom beautier is_on_appveyor
#' @importFrom beautier is_on_ci
#' @importFrom beautier is_on_github_actions
#' @importFrom beautier is_on_travis
#' @importFrom beautier is_one_bool
#' @importFrom beautier is_one_div_x_distr
#' @importFrom beautier is_one_double
#' @importFrom beautier is_one_int
#' @importFrom beautier is_one_na
#' @importFrom beautier is_param
#' @importFrom beautier is_param_name
#' @importFrom beautier is_phylo
#' @importFrom beautier is_poisson_distr
#' @importFrom beautier is_rate_ac_param
#' @importFrom beautier is_rate_ag_param
#' @importFrom beautier is_rate_at_param
#' @importFrom beautier is_rate_cg_param
#' @importFrom beautier is_rate_ct_param
#' @importFrom beautier is_rate_gt_param
#' @importFrom beautier is_rln_clock_model
#' @importFrom beautier is_s_param
#' @importFrom beautier is_scale_param
#' @importFrom beautier is_sigma_param
#' @importFrom beautier is_site_model
#' @importFrom beautier is_site_model_name
#' @importFrom beautier is_strict_clock_model
#' @importFrom beautier is_tn93_site_model
#' @importFrom beautier is_tree_prior
#' @importFrom beautier is_tree_prior_name
#' @importFrom beautier is_uniform_distr
#' @importFrom beautier is_xml
#' @importFrom beautier is_yule_tree_prior
#' @importFrom beautier remove_beautier_folder
#' @importFrom beautier remove_empty_lines
#' @importFrom beautier remove_multiline
#' @importFrom beautier rename_inference_model_filenames
#' @importFrom beautier rename_mcmc_filenames
#' @importFrom beautier unindent
#' @importFrom tracerer calc_act
#' @importFrom tracerer calc_act_r
#' @importFrom tracerer calc_ess
#' @importFrom tracerer calc_esses
#' @importFrom tracerer calc_geom_mean
#' @importFrom tracerer calc_hpd_interval
#' @importFrom tracerer calc_mode
#' @importFrom tracerer calc_stderr_mean
#' @importFrom tracerer calc_summary_stats
#' @importFrom tracerer calc_summary_stats_trace
#' @importFrom tracerer calc_summary_stats_traces
#' @importFrom tracerer check_trace
#' @importFrom tracerer count_trees_in_file
#' @importFrom tracerer extract_operators_lines
#' @importFrom tracerer get_tracerer_path
#' @importFrom tracerer get_tracerer_paths
#' @importFrom tracerer get_tracerer_tempfilename
#' @importFrom tracerer is_posterior
#' @importFrom tracerer is_trees_file
#' @importFrom tracerer is_trees_posterior
#' @importFrom tracerer parse_beast_log
#' @importFrom tracerer parse_beast_output_files
#' @importFrom tracerer parse_beast_posterior
#' @importFrom tracerer parse_beast_state_operators
#' @importFrom tracerer parse_beast_tracelog_file
#' @importFrom tracerer parse_beast_trees
#' @importFrom tracerer remove_burn_in
#' @importFrom tracerer remove_burn_ins
#' @importFrom tracerer save_beast_estimates
#' @importFrom tracerer save_beast_trees
#' @importFrom beastier add_quotes_if_has_spaces
#' @importFrom beastier are_beast2_input_lines
#' @importFrom beastier are_beast2_input_lines_deep
#' @importFrom beastier are_beast2_input_lines_fast
#' @importFrom beastier are_identical_alignments
#' @importFrom beastier beastier_report
#' @importFrom beastier check_beast2
#' @importFrom beastier check_beast2_options
#' @importFrom beastier check_beast2_options_data_types
#' @importFrom beastier check_beast2_options_do_not_overwrite_existing_files
#' @importFrom beastier check_beast2_options_filenames_differ
#' @importFrom beastier check_beast2_options_names
#' @importFrom beastier check_beast2_optionses
#' @importFrom beastier check_beast2_path
#' @importFrom beastier check_can_create_dir_for_state_output_file
#' @importFrom beastier check_can_create_file
#' @importFrom beastier check_can_create_screenlog_file
#' @importFrom beastier check_can_create_state_output_file
#' @importFrom beastier check_can_create_tracelog_file
#' @importFrom beastier check_can_create_treelog_file
#' @importFrom beastier check_empty_beastier_folder
#' @importFrom beastier check_empty_beaustier_folders
#' @importFrom beastier check_input_filename
#' @importFrom beastier check_input_filename_validity
#' @importFrom beastier check_n_threads
#' @importFrom beastier check_os
#' @importFrom beastier check_rng_seed
#' @importFrom beastier continue_beast2
#' @importFrom beastier create_beast2_continue_cmd_from_options
#' @importFrom beastier create_beast2_input_file_folder
#' @importFrom beastier create_beast2_options
#' @importFrom beastier create_beast2_run_cmd
#' @importFrom beastier create_beast2_run_cmd_from_options
#' @importFrom beastier create_beast2_screenlog_folder
#' @importFrom beastier create_beast2_state_output_file_folder
#' @importFrom beastier create_beast2_tracelog_folder
#' @importFrom beastier create_beast2_treelog_folder
#' @importFrom beastier create_beast2_validate_cmd
#' @importFrom beastier create_beast2_validate_cmd_bin
#' @importFrom beastier create_beast2_validate_cmd_jar
#' @importFrom beastier create_beast2_version_cmd
#' @importFrom beastier create_beast2_version_cmd_bin
#' @importFrom beastier create_beast2_version_cmd_jar
#' @importFrom beastier create_beastier_tempfolder
#' @importFrom beastier create_mcbette_beast2_options
#' @importFrom beastier create_random_alignment
#' @importFrom beastier create_random_fasta
#' @importFrom beastier create_random_phylogeny
#' @importFrom beastier create_temp_input_filename
#' @importFrom beastier create_temp_state_filename
#' @importFrom beastier extract_screenlog_filename_from_beast2_input_file
#' @importFrom beastier extract_tracelog_filename_from_beast2_input_file
#' @importFrom beastier extract_treelog_filename_from_beast2_input_file
#' @importFrom beastier get_alignment_ids_from_xml_filename
#' @importFrom beastier get_beast2_example_filename
#' @importFrom beastier get_beast2_example_filenames
#' @importFrom beastier get_beast2_main_class_name
#' @importFrom beastier get_beast2_options_filenames
#' @importFrom beastier get_beast2_version
#' @importFrom beastier get_beastier_folder
#' @importFrom beastier get_beastier_path
#' @importFrom beastier get_beastier_paths
#' @importFrom beastier get_beastier_tempfilename
#' @importFrom beastier get_default_beast2_bin_path
#' @importFrom beastier get_default_beast2_download_url
#' @importFrom beastier get_default_beast2_download_url_linux
#' @importFrom beastier get_default_beast2_download_url_win
#' @importFrom beastier get_default_beast2_folder
#' @importFrom beastier get_default_beast2_jar_path
#' @importFrom beastier get_default_beast2_path
#' @importFrom beastier get_default_beast2_version
#' @importFrom beastier get_default_java_path
#' @importFrom beastier get_duplicate_param_ids
#' @importFrom beastier get_java_version
#' @importFrom beastier get_trees_filenames
#' @importFrom beastier gives_beast2_warning
#' @importFrom beastier has_unique_ids
#' @importFrom beastier install_beast2
#' @importFrom beastier is_alignment
#' @importFrom beastier is_beast2_input_file
#' @importFrom beastier is_beast2_installed
#' @importFrom beastier is_bin_path
#' @importFrom beastier is_jar_path
#' @importFrom beastier is_win_bin_path
#' @importFrom beastier print_beast2_options
#' @importFrom beastier remove_beastier_folder
#' @importFrom beastier remove_beaustier_folders
#' @importFrom beastier remove_file_if_present
#' @importFrom beastier rename_beast2_options_filenames
#' @importFrom beastier run_beast2
#' @importFrom beastier run_beast2_from_options
#' @importFrom beastier save_lines
#' @importFrom beastier save_nexus_as_fasta
#' @importFrom beastier uninstall_beast2
#' @importFrom mauricer get_beast2_pkg_names
#' @importFrom mauricer get_mrc_path
#' @importFrom mauricer get_mrc_paths
#' @importFrom mauricer install_beast2_pkg
#' @importFrom mauricer is_beast2_ns_pkg_installed
#' @importFrom mauricer is_beast2_pkg_installed
#' @importFrom mauricer uninstall_beast2_pkg
NULL
