% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/babette.R
\docType{package}
\name{babette}
\alias{babette}
\title{babette: A package for Bayesian phylogenetics.}
\description{
'babette' provides for an alternative workflow of using
the popular phylogenetics tool 'BEAST2', including
it peripheral tools. From an alignment and
inference model, a posterior of jointly estimated
phylogenies and parameter estimates is generated.
}
\note{
the imports are created by script 'scripts/create_imports.R'
}
\examples{
if (beautier::is_on_ci() && is_beast2_installed()) {
  beastier::remove_beaustier_folders()
  beastier::check_empty_beaustier_folders()

  inference_model <- create_test_inference_model()
  beast2_options <- create_beast2_options()

  bbt_run_from_model(
    fasta_filename = get_babette_path("anthus_aco.fas"),
    inference_model = inference_model,
    beast2_options = beast2_options
  )

  # Clean up temporary files created by babette
  bbt_delete_temp_files(
    inference_model = inference_model,
    beast2_options = beast2_options
  )
  beastier::remove_beaustier_folders()
  beastier::check_empty_beaustier_folders()
}
beastier::remove_beaustier_folders()
}
\seealso{
Use \link{bbt_self_test} to do verify \link{babette} is installed
correctly.\cr

These are packages associated with 'babette':
\itemize{
  \item{
    '\link[beautier]{beautier}' creates 'BEAST2' input files.
  }
  \item{
    '\link[beastier]{beastier}' runs 'BEAST2'.
  }
  \item{
    '\link[mauricer]{mauricer}' does 'BEAST2' package management.
  }
  \item{
    '\link[tracerer]{tracerer}' parses 'BEAST2' output files.
  }
}
}
\author{
Richèl J.C. Bilderbeek
}
