% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_beast2_output.R
\name{parse_beast2_output}
\alias{parse_beast2_output}
\title{Process the 'BEAST2' output dependent on 'BEAST2' package specifics}
\usage{
parse_beast2_output(out, inference_model)
}
\arguments{
\item{out}{a list with the complete babette output, with elements:
\itemize{
  \item \code{output} textual output of a 'BEAST2' run
}}

\item{inference_model}{a Bayesian phylogenetic inference model,
as returned by \link[beautier]{create_inference_model}}
}
\value{
complete babette output with added attributes,
  which depends on the 'BEAST2' package.
  \itemize{
    \item \code{marg_log_lik} the marginal log likelihood estimate
    \item \code{marg_log_lik_sd} the standard deviation around the estimate
    \item \code{estimates} the parameter estimates
      created during the marginal likelihood estimation
    \item \code{trees} the trees
      created during the marginal likelihood estimation
  }
}
\description{
Process the 'BEAST2' output dependent on 'BEAST2' package specifics
}
\author{
Richèl J.C. Bilderbeek
}
