% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/babsimTools.R
\name{getInfectedPerDay}
\alias{getInfectedPerDay}
\title{getInfectedPerDay}
\usage{
getInfectedPerDay(lambda = 4, StartDate = "2020-03-03", EndDate = "2020-06-24")
}
\arguments{
\item{lambda}{Expected number of infections/day.}

\item{StartDate}{Day, simulation starts}

\item{EndDate}{Day, simulation ends}
}
\value{
This function returns a vector that lists the number of infections.
}
\description{
Generate Poisson distributed infections.
This function calculates \code{n}, the number of days between \code{StartDate}
and \code{EndDate}, and returns a vector with \code{n} realizations of a  
Poisson(lambda) distributed random variable.
}
\examples{
StartDate <- "2020-03-03"
EndDate <- "2020-06-24"
getInfectedPerDay(lambda = 4, StartDate = StartDate, EndDate = EndDate)
}
