% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/babsimPara.R
\name{smoothParameter}
\alias{smoothParameter}
\title{Smooth a parameter set using another parameter set}
\usage{
smoothParameter(para, other, weight = 0.2)
}
\arguments{
\item{para}{Parameter set to smooth}

\item{other}{Other parameters to average in}

\item{weight}{Weight of other parameters}
}
\value{
Weighted parameter set
}
\description{
Calculate the average of two parameter sets to smooth out any local anomalies.
Mostly useful to smooth out a local (say OBK) parameter set using a global one (say NRW).

Technically this function calculates 
  \code{(1-weight) * para + weight * other}
ensuring that the names etc. of \code{para} are preserved.
}
