% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funOptimizeSim.R
\name{funOptimizeSim}
\alias{funOptimizeSim}
\title{funOptimizeSim}
\usage{
funOptimizeSim(x, conf, data, ...)
}
\arguments{
\item{x}{num:  real values. Will be interpreted as parameter values for \code{\link{babsimHospital}}.
Names of these parameters can be obtained via \code{\link{getParameterName}}.}

\item{conf}{list with the following entries:
\describe{
\item{\code{seed}}{seed. Default: 123}
\item{\code{simRepeats}}{simmer repeats}
\item{\code{parallel}}{simmer parallel runs. Default: FALSE}
\item{\code{perCores}}{percentage of cores used for parallel simmer simulations. Default: 0.5 (=50 percent)}
\item{\code{ICU}}{use ICU infection data. Default: FALSE}
\item{\code{logLevel}}{log leved (0 or 1). Default: 0 (no output)}
}}

\item{data}{list with simData and fieldData}

\item{...}{additional variables}
}
\value{
This function returns a real value, that represents the combined rmse from the three beds
types.
}
\description{
Interface function to evaluate one parameter configuration
from \code{\link{babsimHospitalPara}}
}
\examples{
x <- getStartParameter()
conf <- babsimToolsConf()
data <- getObkData()
err <- funOptimizeSim(x = x, conf = conf, data = data)
}
