% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{bootstrapBackShift}
\alias{bootstrapBackShift}
\title{Computes a simple model-based bootstrap confidence interval for success of joint diagonalization
procedure. The model-based bootstrap approach assumes normally distributed error terms; the
parameters of the noise distribution are estimated with maximum likelihood.}
\usage{
bootstrapBackShift(Ahat, X, ExpInd, nrep, alpha = 0.05, covariance = TRUE,
  baseInd = 1, tolerance = 0.001, verbose = FALSE)
}
\arguments{
\item{Ahat}{Estimated connectivity matrix returned by \code{backShift}.}

\item{X}{A (nxp)-dimensional matrix (or data frame) with n observations of p variables.}

\item{ExpInd}{Indicator of the experiment or the intervention type an observation belongs to. A numeric vector of length n. Has to contain at least three different unique values.}

\item{nrep}{Number of bootstrap samples.}

\item{alpha}{Significance level for confidence interval.}

\item{covariance}{A boolean variable. If \code{TRUE}, use only shift in covariance matrix; otherwise use shift in Gram matrix. Set only to \code{FALSE} if at most one variable has a non-zero shift in mean in the same setting (default is \code{TRUE}).}

\item{baseInd}{Index for baseline environment against which the intervention variances are measured. Defaults to 1.}

\item{tolerance}{Precision parameter for \code{ffdiag}: the algorithm stops when the criterium difference between two iterations is less than \code{tolerance}. Default is 10^(-4).}

\item{verbose}{If \code{FALSE}, messages are supressed.}
}
\value{
A list with the following elements: 
\itemize{
 \item \code{bootsSumOffDiags} Vector of length \code{nrep} with sum of off-diagonal elements after joint diagnolization procedure in each of the bootstrap samples.
 \item \code{sumOffDiagsBackShift} Sum of off-diagonal elements after joint diagnolization procedure in original estimation.
 \item \code{jointDiagSuccess} \code{TRUE} if \code{sumOffDiagsBackShift} lies 
 within bootstrap confidence interval.
 \item \code{lower} Lower bound of bootstrap confidence interval. 
 \item \code{upper} Upper bound of bootstrap confidence interval. 
 \item \code{lowerBasic} \code{alpha/2} quantile of empirical bootstrap distribution.
 \item \code{upperBasic} \code{1 - alpha/2} quantile of empirical bootstrap distribution.
 }
}
\description{
Computes a simple model-based bootstrap confidence interval for success of joint diagonalization
procedure. The model-based bootstrap approach assumes normally distributed error terms; the
parameters of the noise distribution are estimated with maximum likelihood.
}

