% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/b2UploadFile.R
\name{b2UploadFile}
\alias{b2UploadFile}
\title{Upload File to B2.}
\usage{
b2UploadFile(authToken, uploadUrl, fileName)
}
\arguments{
\item{authToken}{A unique authorisation token permiting the upload of files
to B2. An authorisation token is obtained from \code{b2UploadUrl}.}

\item{uploadUrl}{A unique URL permiting the upload of files to B2. An upload
URL is obtained from \code{b2UploadUrl}.}

\item{fileName}{The name of the file to be uploaded. Files must be located in
the current working directory. A complete list of supported file types may
be found in the b2FileTypes.rds file located in this package's data
directory, or at the following location:
\url{https://www.backblaze.com/b2/docs/content-types.html}}
}
\value{
If successful a list containing the \code{fileId}, \code{fileName},
  \code{accountId}, \code{bucketId}, \code{contentLength},
  \code{contentSha1}, \code{contentType} and \code{fileInfo} will all be
  echoed back to the user.
}
\description{
\code{b2Uploadfile} Uploads one file to the user's account B2.
}
\details{
This function uploads one file to the user's account on the Backblaze B2
cloud storage product, returning a unique file ID. Files cannot be uploaded
to B2 unless \code{GetUploadUrl} has been executed first, specifying the
bucket in which to upload the file. Further details regarding this API call
are available here:

\url{https://www.backblaze.com/b2/docs/b2_upload_file.html}

\code{authToken}, \code{uploadUrl} and \code{fileName} are mandatory and must
be user defined.
}
\examples{
\dontrun{
# Make a bucket Private
# Get Upload URL
uploadUrlReturn <- b2GetUploadUrl(bucketId = "aUniqueBucketId")
uploadUrl <- uploadUrlReturn$uploadUrl
authToken <- uploadUrlReturn$authorizationToken
# Upload file
b2UploadFile(authToken, uploadUrl, fileName = "yourFileName.png")
}

}

