% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fdsm.R
\name{fdsm}
\alias{fdsm}
\title{The fixed degree sequence model (fdsm)}
\usage{
fdsm(B, trials = 1000, sparse = TRUE, dyad = NULL,
  progress = FALSE)
}
\arguments{
\item{B}{Matrix: Bipartite adjacency matrix}

\item{trials}{Integer: Number of random bipartite graphs generated}

\item{sparse}{Boolean: If sparse matrix manipulations should be used}

\item{dyad}{vector length 2: two row entries i,j. Saves each value of the i-th row and j-th column in each projected B* matrix. This is useful for visualizing an example of the empirical null edge weight distribution generated by the model. These correspond to the row and column indices of a cell in the projected matrix , and can be written as their string row names or as numeric values.}

\item{progress}{Boolean: If \link[utils]{txtProgressBar} should be used to measure progress}
}
\value{
list(positive, negative, dyad_values).
positive: matrix of proportion of times each entry of the projected matrix B is above the corresponding entry in the generated projection.
negative: matrix of proportion of times each entry of the projected matrix B is below the corresponding entry in the generated projection.
dyad_values: list of edge weight for i,j in each generated projection.
}
\description{
`fdsm` computes the proportion of generated edges above
    or below the observed value using the fixed degree sequence model.
    Once computed, use \code{\link{backbone.extract}} to
    return the backbone matrix for a given alpha value.
}
\details{
During each iteration, fdsm computes a new B* matrix using the Curveball algorithm. This is a random bipartite matrix with the same row and column sums as the original matrix B.
    If the dyad_parameter is indicated to be used in the parameters, when the B* matrix is projected, the projected value for the corresponding row and column will be saved.
    This allows the user to see the distribution of the edge weights for desired row and column.
}
\examples{
fdsm_props <- fdsm(davis, trials = 100, sparse = TRUE, dyad=c(3,6))
}
\references{
fixed degree sequence model: \href{https://doi.org/10.1007/s13278-011-0021-0}{Zweig, Katharina Anna, and Michael Kaufmann. 2011. “A Systematic Approach to the One-Mode Projection of Bipartite Graphs.” Social Network Analysis and Mining 1 (3): 187–218. DOI: 10.1007/s13278-011-0021-0.}

curveball algorithm: \href{https://www.nature.com/articles/ncomms5114}{Strona, Giovanni, Domenico Nappo, Francesco Boccacci, Simone Fattorini, and Jesus San-Miguel-Ayanz. 2014. “A Fast and Unbiased Procedure to Randomize Ecological Binary Matrices with Fixed Row and Column Totals.” Nature Communications 5 (June). Nature Publishing Group: 4114. DOI:10.1038/ncomms5114.}
}
